/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.capabilities;

import adams.core.Mergeable;
import adams.core.logging.LoggingObject;
import adams.ml.capabilities.CapabilitiesHandler;
import adams.ml.capabilities.Capability;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Capabilities
extends LoggingObject
implements Mergeable<Capabilities> {
    private static final long serialVersionUID = -3901300565162711500L;
    protected CapabilitiesHandler m_Owner;
    protected Set<Capability> m_Capabilities;
    protected Set<Capability> m_DependentCapabilities;
    protected int m_MinRows;
    protected int m_MaxRows;
    protected int m_MinColumns;
    protected int m_MaxColumns;
    protected int m_MinClassColumns;
    protected int m_MaxClassColumns;

    public Capabilities() {
        this(null);
    }

    public Capabilities(CapabilitiesHandler owner) {
        this.setOwner(owner);
        this.m_Capabilities = new HashSet<Capability>();
        this.m_DependentCapabilities = new HashSet<Capability>();
        this.reset();
    }

    protected void reset() {
        this.m_Capabilities.clear();
        this.m_DependentCapabilities.clear();
        this.m_MinRows = -1;
        this.m_MaxRows = -1;
        this.m_MinColumns = -1;
        this.m_MaxColumns = -1;
        this.m_MinClassColumns = -1;
        this.m_MaxClassColumns = -1;
    }

    public void setOwner(CapabilitiesHandler value) {
        this.m_Owner = value;
    }

    public CapabilitiesHandler getOwner() {
        return this.m_Owner;
    }

    public Capabilities clone() {
        Capabilities result = new Capabilities(this.getOwner());
        result.assign(this);
        return result;
    }

    public void assign(Capabilities other) {
        this.reset();
        this.mergeWith(other);
    }

    protected int widen(int current, int proposed, boolean up) {
        if (current == proposed) {
            return current;
        }
        if (up) {
            if (current == -1) {
                return proposed;
            }
            if (proposed == -1) {
                return current;
            }
            return Math.max(current, proposed);
        }
        if (current == -1) {
            return proposed;
        }
        if (proposed == -1) {
            return current;
        }
        return Math.min(current, proposed);
    }

    public void mergeWith(Capabilities other) {
        for (Capability cap : other.capabilities()) {
            this.enable(cap);
        }
        for (Capability cap : other.dependentCapabilities()) {
            this.enableDependent(cap);
        }
        this.setMinRows(this.widen(this.getMinRows(), other.getMinRows(), false));
        this.setMaxRows(this.widen(this.getMaxRows(), other.getMaxRows(), true));
        this.setMinColumns(this.widen(this.getMinColumns(), other.getMinColumns(), false));
        this.setMaxColumns(this.widen(this.getMaxColumns(), other.getMaxColumns(), true));
        this.setMinClassColumns(this.widen(this.getMinClassColumns(), other.getMinClassColumns(), false));
        this.setMaxClassColumns(this.widen(this.getMaxClassColumns(), other.getMaxClassColumns(), true));
    }

    public Set<Capability> capabilities() {
        return this.m_Capabilities;
    }

    public Set<Capability> dependentCapabilities() {
        return this.m_DependentCapabilities;
    }

    public void enable(Capability cap) {
        this.m_Capabilities.add(cap);
    }

    public void disable(Capability cap) {
        this.m_Capabilities.remove((Object)cap);
    }

    public void enableAll(Collection<Capability> caps) {
        for (Capability cap : caps) {
            this.enable(cap);
        }
    }

    public void disableAll(Collection<Capability> caps) {
        for (Capability cap : caps) {
            this.disable(cap);
        }
    }

    public void enableAll() {
        for (Capability cap : Capability.values()) {
            this.enable(cap);
        }
    }

    public void disableAll() {
        for (Capability cap : Capability.values()) {
            this.disable(cap);
        }
    }

    public void enableAllClass() {
        for (Capability cap : Capability.values()) {
            if (!cap.isClassRelated()) continue;
            this.enable(cap);
        }
    }

    public void disableAllClass() {
        for (Capability cap : Capability.values()) {
            if (!cap.isClassRelated()) continue;
            this.disable(cap);
        }
    }

    public boolean isEnabled(Capability cap) {
        return this.m_Capabilities.contains((Object)cap);
    }

    public void enableDependent(Capability cap) {
        this.m_DependentCapabilities.add(cap);
    }

    public void disableDependent(Capability cap) {
        this.m_DependentCapabilities.remove((Object)cap);
    }

    public void enableAllDependent(Collection<Capability> caps) {
        for (Capability cap : caps) {
            this.enableDependent(cap);
        }
    }

    public void disableAllDependent(Collection<Capability> caps) {
        for (Capability cap : caps) {
            this.disableDependent(cap);
        }
    }

    public void enableAllDependent() {
        for (Capability cap : this.capabilities()) {
            this.enableDependent(cap);
        }
    }

    public void disableAllDependent() {
        for (Capability cap : this.dependentCapabilities()) {
            this.disableDependent(cap);
        }
    }

    public boolean isDependentEnabled(Capability cap) {
        return this.m_DependentCapabilities.contains((Object)cap);
    }

    public void setMinRows(int value) {
        if (value < -1) {
            value = -1;
        }
        this.m_MinRows = value;
    }

    public int getMinRows() {
        return this.m_MinRows;
    }

    public void setMaxRows(int value) {
        if (value < -1) {
            value = -1;
        }
        this.m_MaxRows = value;
    }

    public int getMaxRows() {
        return this.m_MaxRows;
    }

    public void setMinColumns(int value) {
        if (value < -1) {
            value = -1;
        }
        this.m_MinColumns = value;
    }

    public int getMinColumns() {
        return this.m_MinColumns;
    }

    public void setMaxColumns(int value) {
        if (value < -1) {
            value = -1;
        }
        this.m_MaxColumns = value;
    }

    public int getMaxColumns() {
        return this.m_MaxColumns;
    }

    public void setMinClassColumns(int value) {
        if (value < -1) {
            value = -1;
        }
        this.m_MinClassColumns = value;
    }

    public int getMinClassColumns() {
        return this.m_MinClassColumns;
    }

    public void setMaxClassColumns(int value) {
        if (value < -1) {
            value = -1;
        }
        this.m_MaxClassColumns = value;
    }

    public int getMaxClassColumns() {
        return this.m_MaxClassColumns;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        ArrayList<Capability> caps = new ArrayList<Capability>(this.capabilities());
        Collections.sort(caps);
        result.append("Capabilities: ").append(((Object)caps).toString());
        result.append("\n");
        caps = new ArrayList<Capability>(this.dependentCapabilities());
        Collections.sort(caps);
        result.append("Dependent capabilities: ").append(((Object)caps).toString());
        result.append("\n");
        result.append("Rows: ").append("min=").append(this.getMinRows()).append(", max=").append(this.getMaxRows());
        result.append("\n");
        result.append("Columns: ").append("min=").append(this.getMinColumns()).append(", max=").append(this.getMaxColumns());
        result.append("\n");
        result.append("Class columns: ").append("min=").append(this.getMinClassColumns()).append(", max=").append(this.getMaxClassColumns());
        return result.toString();
    }
}

