/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.data;

import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetHelper;
import adams.ml.data.Dataset;
import com.github.waikatodatamining.matrix.core.Matrix;
import com.github.waikatodatamining.matrix.core.MatrixFactory;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.List;

public class DatasetUtils
extends SpreadSheetHelper {
    public static int[] getNumericColumns(Dataset data) {
        TIntArrayList result = new TIntArrayList();
        for (int i = 0; i < data.getColumnCount(); ++i) {
            if (!data.isNumeric(i)) continue;
            result.add(i);
        }
        return result.toArray();
    }

    public static Jama.Matrix numericToJama(Dataset data) {
        return DatasetUtils.numericToJama(data, DatasetUtils.getNumericColumns(data));
    }

    public static Jama.Matrix numericToJama(Dataset data, int[] cols) {
        Jama.Matrix result = new Jama.Matrix(data.getRowCount(), cols.length);
        for (int y = 0; y < data.getRowCount(); ++y) {
            for (int x = 0; x < cols.length; ++x) {
                result.set(y, x, data.getRow(y).getCell(cols[x]).toDouble().doubleValue());
            }
        }
        return result;
    }

    public static Matrix numericToMatrixAlgo(Dataset data) {
        return DatasetUtils.numericToMatrixAlgo(data, DatasetUtils.getNumericColumns(data));
    }

    public static Matrix numericToMatrixAlgo(Dataset data, int[] cols) {
        Matrix result = MatrixFactory.zeros((int)data.getRowCount(), (int)cols.length);
        for (int y = 0; y < data.getRowCount(); ++y) {
            for (int x = 0; x < cols.length; ++x) {
                result.set(y, x, data.getRow(y).getCell(cols[x]).toDouble().doubleValue());
            }
        }
        return result;
    }

    public static List<double[]> numericToArrays(Dataset data) {
        return DatasetUtils.numericToArrays(data, DatasetUtils.getNumericColumns(data));
    }

    public static List<double[]> numericToArrays(Dataset data, int[] cols) {
        ArrayList<double[]> result = new ArrayList<double[]>();
        for (Row row : data.rows()) {
            double[] array = new double[cols.length];
            for (int x : cols) {
                array[x] = row.getCell(x).toDouble();
            }
            result.add(array);
        }
        return result;
    }

    public static SpreadSheet matrixAlgoToSpreadSheet(Matrix data, String colPrefix) {
        int x;
        DefaultSpreadSheet result = new DefaultSpreadSheet();
        HeaderRow row = result.getHeaderRow();
        for (x = 0; x < data.numColumns(); ++x) {
            row.addCell("" + x).setContentAsString(colPrefix + (x + 1));
        }
        for (int y = 0; y < data.numRows(); ++y) {
            row = result.addRow();
            for (x = 0; x < data.numColumns(); ++x) {
                row.addCell("" + x).setContent(Double.valueOf(data.get(y, x)));
            }
        }
        return result;
    }
}

