/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.evaluation;

import adams.data.binning.Binnable;
import adams.data.binning.BinnableDataset;
import adams.data.splitgenerator.CrossValidationFoldGenerator;
import adams.data.splitgenerator.generic.crossvalidation.CrossValidationGenerator;
import adams.data.splitgenerator.generic.crossvalidation.FoldPair;
import adams.data.splitgenerator.generic.randomization.AbstractRandomization;
import adams.data.splitgenerator.generic.randomization.DefaultRandomization;
import adams.data.splitgenerator.generic.randomization.PassThrough;
import adams.data.splitgenerator.generic.stratification.AbstractStratification;
import adams.data.splitgenerator.generic.stratification.DefaultStratification;
import adams.data.spreadsheet.DataRow;
import adams.flow.container.TrainTestSetContainer;
import adams.ml.data.Dataset;
import adams.ml.data.DatasetView;
import adams.ml.evaluation.AbstractSplitGenerator;
import gnu.trove.TIntCollection;
import gnu.trove.list.array.TIntArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class DefaultCrossValidationFoldGenerator
extends AbstractSplitGenerator
implements CrossValidationFoldGenerator<Dataset, TrainTestSetContainer> {
    private static final long serialVersionUID = -8387205583429213079L;
    protected int m_NumFolds;
    protected int m_ActualNumFolds;
    protected boolean m_Stratify;
    protected transient int m_CurrentFold;
    protected boolean m_Randomize;
    protected transient CrossValidationGenerator m_Generator;
    protected transient List<FoldPair<Binnable<DataRow>>> m_FoldPairs;

    public DefaultCrossValidationFoldGenerator() {
    }

    public DefaultCrossValidationFoldGenerator(Dataset data, int numFolds, long seed, boolean stratify) {
        this(data, numFolds, seed, true, stratify);
    }

    public DefaultCrossValidationFoldGenerator(Dataset data, int numFolds, long seed, boolean randomize, boolean stratify) {
        this.setData(data);
        this.setSeed(seed);
        this.setNumFolds(numFolds);
        this.setStratify(stratify);
        this.setRandomize(randomize);
    }

    public String globalInfo() {
        return "Generates cross-validation fold pairs. Leave-one-out is performed when specified folds <2.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-folds", "numFolds", (Object)10);
        this.m_OptionManager.add("randomize", "randomize", (Object)true);
        this.m_OptionManager.add("stratify", "stratify", (Object)true);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_CurrentFold = 1;
        this.m_ActualNumFolds = -1;
        this.m_FoldPairs = null;
    }

    @Override
    public void setData(Dataset value) {
        super.setData(value);
        if (this.m_Data != null && this.getStratify() && this.m_Data.getClassAttributeIndices().length == 0) {
            throw new IllegalArgumentException("No class attribute set!");
        }
    }

    @Override
    public void setNumFolds(int value) {
        this.m_NumFolds = value;
        this.reset();
    }

    @Override
    public int getNumFolds() {
        return this.m_NumFolds;
    }

    public String numFoldsTipText() {
        return "The number of folds; use <2 for leave one out (LOO).";
    }

    @Override
    public int getActualNumFolds() {
        return this.m_ActualNumFolds;
    }

    @Override
    public void setRandomize(boolean value) {
        this.m_Randomize = value;
        this.reset();
    }

    @Override
    public boolean getRandomize() {
        return this.m_Randomize;
    }

    public String randomizeTipText() {
        return "If enabled, the data is randomized first.";
    }

    public void setStratify(boolean value) {
        this.m_Stratify = value;
        this.reset();
    }

    public boolean getStratify() {
        return this.m_Stratify;
    }

    public String stratifyTipText() {
        return "If enabled, the folds get stratified in case of a nominal class attribute.";
    }

    @Override
    protected boolean canRandomize() {
        return this.m_Randomize;
    }

    @Override
    protected boolean checkNext() {
        return this.m_CurrentFold <= this.m_ActualNumFolds;
    }

    @Override
    protected void doInitializeIterator() {
        AbstractStratification strat;
        boolean classIsNominal;
        AbstractRandomization rand;
        if (this.m_Data == null) {
            throw new IllegalStateException("No data provided!");
        }
        this.m_ActualNumFolds = this.m_NumFolds < 2 ? this.m_Data.getRowCount() : this.m_NumFolds;
        if (this.m_Data.getRowCount() < this.m_ActualNumFolds) {
            throw new IllegalArgumentException("Cannot have less data than folds: required=" + this.m_ActualNumFolds + ", provided=" + this.m_Data.getRowCount());
        }
        this.m_Generator = new CrossValidationGenerator();
        this.m_Generator.setNumFolds(this.m_NumFolds);
        if (this.canRandomize()) {
            rand = new DefaultRandomization();
            ((DefaultRandomization)rand).setSeed(this.m_Seed);
            rand.setLoggingLevel(this.m_LoggingLevel);
            this.m_Generator.setRandomization(rand);
        } else {
            rand = new PassThrough();
            rand.setLoggingLevel(this.m_LoggingLevel);
            this.m_Generator.setRandomization(rand);
        }
        boolean bl = classIsNominal = !this.m_Data.isNumeric(this.m_Data.getClassAttributeIndices()[0]);
        if (this.m_Stratify && classIsNominal && this.m_ActualNumFolds < this.m_Data.getRowCount()) {
            strat = new DefaultStratification();
            strat.setLoggingLevel(this.m_LoggingLevel);
            this.m_Generator.setStratification(strat);
        } else {
            strat = new adams.data.splitgenerator.generic.stratification.PassThrough();
            strat.setLoggingLevel(this.m_LoggingLevel);
            this.m_Generator.setStratification(strat);
        }
    }

    @Override
    protected TrainTestSetContainer createNext() {
        Dataset test;
        Dataset train;
        if (this.m_CurrentFold > this.m_ActualNumFolds) {
            throw new NoSuchElementException("No more folds available!");
        }
        if (this.m_FoldPairs == null) {
            List binnedData;
            try {
                binnedData = BinnableDataset.toBinnableUsingClass(this.m_Data, this.m_Data.getClassAttributeIndices()[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to create binnable Dataset!", e);
            }
            this.m_FoldPairs = this.m_Generator.generate(binnedData);
            this.m_OriginalIndices = new TIntArrayList();
            for (FoldPair<Binnable<DataRow>> pair : this.m_FoldPairs) {
                this.m_OriginalIndices.addAll((TIntCollection)pair.getTest().getOriginalIndices());
            }
        }
        FoldPair<Binnable<DataRow>> foldPair = this.m_FoldPairs.get(this.m_CurrentFold - 1);
        int[] trainRows = foldPair.getTrain().getOriginalIndices().toArray();
        int[] testRows = foldPair.getTest().getOriginalIndices().toArray();
        if (this.m_UseViews) {
            train = new DatasetView(this.m_Data, trainRows, null);
            test = new DatasetView(this.m_Data, testRows, null);
        } else {
            train = BinnableDataset.toDataset(foldPair.getTrain().getData());
            test = BinnableDataset.toDataset(foldPair.getTest().getData());
        }
        TrainTestSetContainer result = new TrainTestSetContainer(train, test, this.m_Seed, this.m_CurrentFold, this.m_ActualNumFolds, trainRows, testRows);
        ++this.m_CurrentFold;
        if (this.m_CurrentFold > this.m_ActualNumFolds) {
            this.m_FoldPairs = null;
        }
        return result;
    }

    @Override
    public int[] crossValidationIndices() {
        return this.m_OriginalIndices.toArray();
    }

    @Override
    public String toString() {
        return super.toString() + ", numFolds=" + this.m_NumFolds + ", stratify=" + this.m_Stratify;
    }
}

