/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.preprocessing.unsupervised;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.Row;
import adams.ml.capabilities.Capabilities;
import adams.ml.capabilities.Capability;
import adams.ml.data.Dataset;
import adams.ml.data.DefaultDataset;
import adams.ml.preprocessing.AbstractColumnSubsetStreamFilter;

public class SavitzkyGolay
extends AbstractColumnSubsetStreamFilter
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 5753905967950878654L;
    protected int m_PolynomialOrder;
    protected int m_DerivativeOrder;
    protected int m_NumPointsLeft;
    protected int m_NumPointsRight;
    protected double[] m_Coefficients;

    public String globalInfo() {
        return "A filter that applies Savitzky-Golay smoothing.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        return adams.data.utils.SavitzkyGolay.getTechnicalInformation();
    }

    protected void initialize() {
        super.initialize();
        this.m_Coefficients = null;
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("polynomial", "polynomialOrder", (Object)2, (Number)2, null);
        this.m_OptionManager.add("derivative", "derivativeOrder", (Object)1, (Number)0, null);
        this.m_OptionManager.add("left", "numPointsLeft", (Object)3, (Number)0, null);
        this.m_OptionManager.add("right", "numPointsRight", (Object)3, (Number)0, null);
    }

    public void resetCoefficients() {
        this.m_Coefficients = null;
    }

    public void setPolynomialOrder(int value) {
        if (value >= 2) {
            this.m_PolynomialOrder = value;
            this.reset();
            this.resetCoefficients();
        } else {
            this.getLogger().severe("The polynomial order must be at least 2 (provided: " + value + ")!");
        }
    }

    public int getPolynomialOrder() {
        return this.m_PolynomialOrder;
    }

    public String polynomialOrderTipText() {
        return "The polynomial order to use, must be at least 2.";
    }

    public void setDerivativeOrder(int value) {
        if (value >= 0) {
            this.m_DerivativeOrder = value;
            this.reset();
            this.resetCoefficients();
        } else {
            this.getLogger().severe("The order of the derivative must be at least 0 (provided: " + value + ")!");
        }
    }

    public int getDerivativeOrder() {
        return this.m_DerivativeOrder;
    }

    public String derivativeOrderTipText() {
        return "The order of the derivative to use, >= 0.";
    }

    public void setNumPointsLeft(int value) {
        if (value >= 0) {
            this.m_NumPointsLeft = value;
            this.reset();
            this.resetCoefficients();
        } else {
            this.getLogger().severe("The number of points to the left must be at least 0 (provided: " + value + ")!");
        }
    }

    public int getNumPointsLeft() {
        return this.m_NumPointsLeft;
    }

    public String numPointsLeftTipText() {
        return "The number of points left of a data point, >= 0.";
    }

    public void setNumPointsRight(int value) {
        if (value >= 0) {
            this.m_NumPointsRight = value;
            this.reset();
            this.resetCoefficients();
        } else {
            this.getLogger().severe("The number of points to the right must be at least 0 (provided: " + value + ")!");
        }
    }

    public int getNumPointsRight() {
        return this.m_NumPointsRight;
    }

    public String numPointsRightTipText() {
        return "The number of points right of a data point, >= 0.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities(this);
        result.enable(Capability.NUMERIC_ATTRIBUTE);
        result.enableAllClass();
        return result;
    }

    @Override
    protected void doInitFilter(Row data) throws Exception {
        if (this.m_DataColumns.size() < this.m_NumPointsLeft + this.m_NumPointsRight + 1) {
            throw new Exception("Not enough data columns available for window size: " + this.m_DataColumns.size() + " < " + (this.m_NumPointsLeft + this.m_NumPointsRight + 1));
        }
        this.m_Coefficients = adams.data.utils.SavitzkyGolay.determineCoefficients((int)this.m_NumPointsLeft, (int)this.m_NumPointsRight, (int)this.m_PolynomialOrder, (int)this.m_DerivativeOrder, (boolean)this.isLoggingEnabled());
    }

    @Override
    protected Dataset initOutputFormat(Row data) throws Exception {
        DefaultDataset result = new DefaultDataset();
        HeaderRow row = result.getHeaderRow();
        for (int i = 0; i <= this.m_DataColumns.size() - this.m_Coefficients.length; ++i) {
            row.addCell("" + row.getCellCount()).setContentAsString("att" + (i + 1));
        }
        this.appendHeader(data.getOwner(), (Row)row, this.m_OtherColumns);
        this.appendHeader(data.getOwner(), (Row)row, this.m_ClassColumns);
        return result;
    }

    @Override
    protected Row doFilter(Row data) throws Exception {
        DataRow result = this.getOutputFormat().addRow();
        int width = this.m_NumPointsLeft + this.m_NumPointsRight + 1;
        for (int i = 0; i <= this.m_DataColumns.size() - width; ++i) {
            double value = 0.0;
            for (int n = 0; n < width; ++n) {
                value += this.m_Coefficients[n] * data.getCell(this.m_DataColumns.get(i + n)).toDouble();
            }
            result.getCell(i).setContent(Double.valueOf(value));
        }
        this.appendData(data, (Row)result, this.m_OtherColumns);
        this.appendData(data, (Row)result, this.m_ClassColumns);
        return result;
    }
}

