/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control.removeoutliers;

import adams.core.io.FileUtils;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.flow.control.removeoutliers.AbstractOutlierDetector;
import adams.test.AbstractDatabaseTestCase;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class AbstractOutlierDetectorTestCase
extends AbstractDatabaseTestCase {
    public AbstractOutlierDetectorTestCase(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/flow/control/removeoutliers/data");
    }

    protected List<Integer> process(SpreadSheet sheet, SpreadSheetColumnIndex actual, SpreadSheetColumnIndex predicted, AbstractOutlierDetector scheme) {
        Set outliers = scheme.detect(sheet, actual, predicted);
        ArrayList<Integer> result = new ArrayList<Integer>(outliers);
        Collections.sort(result);
        return result;
    }

    protected String toString(Collection<Integer> data) {
        StringBuilder result = new StringBuilder();
        Iterator<Integer> iter = data.iterator();
        while (iter.hasNext()) {
            result.append(iter.next()).append("\n");
        }
        return result.toString();
    }

    protected boolean save(Collection<Integer> data, String filename) {
        return FileUtils.writeToFile((String)new TmpFile(filename).getAbsolutePath(), (Object)this.toString(data), (boolean)false);
    }

    protected SpreadSheet load(String filename) {
        if (!this.m_TestHelper.copyResourceToTmp(filename)) {
            throw new IllegalStateException("Failed to copy '" + filename + "' to tmp dir!");
        }
        TmpFile file = new TmpFile(filename);
        CsvSpreadSheetReader reader = new CsvSpreadSheetReader();
        return reader.read((File)file);
    }

    protected abstract SpreadSheet[] getRegressionSpreadSheets();

    protected abstract SpreadSheetColumnIndex[] getRegressionActualCols();

    protected abstract SpreadSheetColumnIndex[] getRegressionPredictedCols();

    protected abstract AbstractOutlierDetector[] getRegressionSetups();

    protected abstract int[] getRegressionIgnoredLineIndices();

    protected String createOutputFilename(int no) {
        return "out-" + no + ".txt";
    }

    public void testRegression() {
        int i;
        if (this.m_NoRegressionTest) {
            return;
        }
        AbstractOutlierDetector[] setups = this.getRegressionSetups();
        SpreadSheet[] sheets = this.getRegressionSpreadSheets();
        SpreadSheetColumnIndex[] actCols = this.getRegressionActualCols();
        SpreadSheetColumnIndex[] predCols = this.getRegressionPredictedCols();
        String[] output = new String[setups.length];
        int[] ignored = this.getRegressionIgnoredLineIndices();
        AbstractOutlierDetectorTestCase.assertEquals((String)"Number of sheets and setups differ!", (int)sheets.length, (int)setups.length);
        AbstractOutlierDetectorTestCase.assertEquals((String)"Number of sheets and actual columns differ!", (int)sheets.length, (int)actCols.length);
        AbstractOutlierDetectorTestCase.assertEquals((String)"Number of sheets and predicted columns differ!", (int)sheets.length, (int)predCols.length);
        for (int n = 0; n < setups.length; ++n) {
            output[n] = this.createOutputFilename(n);
            AbstractOutlierDetector current = (AbstractOutlierDetector)OptionUtils.shallowCopy((OptionHandler)setups[n], (boolean)false);
            AbstractOutlierDetectorTestCase.assertNotNull((String)("Failed to create copy of outlier detector: " + OptionUtils.getCommandLine((Object)setups[n])), (Object)current);
            List<Integer> processed = this.process(sheets[n], actCols[n], predCols[n], current);
            AbstractOutlierDetectorTestCase.assertNotNull((String)("Failed to process sheet: " + actCols[n].getIndex() + "/" + predCols[n].getIndex()), processed);
            boolean ok = this.save(processed, output[n]);
            AbstractOutlierDetectorTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
            current.destroy();
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles, ignored);
        AbstractOutlierDetectorTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            setups[i].destroy();
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
    }

    protected void cleanUpAfterRegression() {
    }
}

