/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control.removeoutliers;

import adams.core.ObjectCopyHelper;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.env.Environment;
import adams.flow.control.removeoutliers.AbstractOutlierDetector;
import adams.flow.control.removeoutliers.AbstractOutlierDetectorTestCase;
import adams.flow.control.removeoutliers.IQR;
import adams.flow.control.removeoutliers.MultiOutlierDetector;
import adams.flow.control.removeoutliers.StdDev;
import junit.framework.Test;
import junit.framework.TestSuite;

public class MultiOutlierDetectorTest
extends AbstractOutlierDetectorTestCase {
    public MultiOutlierDetectorTest(String name) {
        super(name);
    }

    @Override
    protected SpreadSheet[] getRegressionSpreadSheets() {
        return new SpreadSheet[]{this.load("bolts_predictions.csv"), this.load("bolts_predictions.csv"), this.load("bolts_predictions.csv")};
    }

    @Override
    protected SpreadSheetColumnIndex[] getRegressionActualCols() {
        return new SpreadSheetColumnIndex[]{new SpreadSheetColumnIndex("Actual"), new SpreadSheetColumnIndex("Actual"), new SpreadSheetColumnIndex("Actual")};
    }

    @Override
    protected SpreadSheetColumnIndex[] getRegressionPredictedCols() {
        return new SpreadSheetColumnIndex[]{new SpreadSheetColumnIndex("Predicted"), new SpreadSheetColumnIndex("Predicted"), new SpreadSheetColumnIndex("Predicted")};
    }

    @Override
    protected AbstractOutlierDetector[] getRegressionSetups() {
        IQR iqr = new IQR();
        iqr.setFactor(1.5);
        MultiOutlierDetector[] result = new MultiOutlierDetector[3];
        result[0] = new MultiOutlierDetector();
        result[1] = new MultiOutlierDetector();
        result[1].setCombination(MultiOutlierDetector.Combination.UNION);
        result[1].setDetectors(new AbstractOutlierDetector[]{new StdDev(), (AbstractOutlierDetector)ObjectCopyHelper.copyObject((Object)iqr)});
        result[2] = new MultiOutlierDetector();
        result[2].setCombination(MultiOutlierDetector.Combination.INTERSECT);
        result[2].setDetectors(new AbstractOutlierDetector[]{new StdDev(), (AbstractOutlierDetector)ObjectCopyHelper.copyObject((Object)iqr)});
        return result;
    }

    @Override
    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }

    public static Test suite() {
        return new TestSuite(MultiOutlierDetectorTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        MultiOutlierDetectorTest.runTest((Test)MultiOutlierDetectorTest.suite());
    }
}

