/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.preparefilebaseddataset;

import adams.core.classmanager.ClassManager;
import adams.core.io.FileUtils;
import adams.core.option.OptionUtils;
import adams.flow.container.FileBasedDatasetContainer;
import adams.flow.transformer.preparefilebaseddataset.AbstractFileBasedDatasetPreparation;
import adams.test.AdamsTestCase;
import adams.test.TmpFile;
import java.io.File;
import java.util.List;

public abstract class AbstractFileBasedDatasetPreparationTestCase<T>
extends AdamsTestCase {
    public AbstractFileBasedDatasetPreparationTestCase(String name) {
        super(name);
    }

    protected List<FileBasedDatasetContainer> process(T files, AbstractFileBasedDatasetPreparation<T> scheme) {
        return scheme.prepare(files);
    }

    protected boolean save(List<FileBasedDatasetContainer> data, String filename) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < data.size(); ++i) {
            if (i > 0) {
                str.append("\n");
            }
            str.append(data.get(i).toString());
        }
        return FileUtils.writeToFile((String)(this.m_TestHelper.getTmpDirectory() + File.separator + filename), (Object)str, (boolean)false);
    }

    protected abstract T getRegressionInputData();

    protected abstract AbstractFileBasedDatasetPreparation<T>[] getRegressionSetups();

    protected String createOutputFilename(int no) {
        return "out" + no + ".txt";
    }

    public void testRegression() {
        int i;
        if (this.m_NoRegressionTest) {
            return;
        }
        T input = this.getRegressionInputData();
        AbstractFileBasedDatasetPreparation<T>[] setups = this.getRegressionSetups();
        String[] output = new String[setups.length];
        for (i = 0; i < setups.length; ++i) {
            AbstractFileBasedDatasetPreparation current = (AbstractFileBasedDatasetPreparation)ClassManager.getSingleton().deepCopy(setups[i]);
            AbstractFileBasedDatasetPreparationTestCase.assertNotNull((String)("Failed to create copy of algorithm: " + OptionUtils.getCommandLine(setups[i])), (Object)current);
            List<FileBasedDatasetContainer> processed = this.process(input, current);
            AbstractFileBasedDatasetPreparationTestCase.assertNotNull((String)"Failed to process data?", processed);
            output[i] = this.createOutputFilename(i);
            boolean ok = this.save(processed, output[i]);
            AbstractFileBasedDatasetPreparationTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
            current.destroy();
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles);
        AbstractFileBasedDatasetPreparationTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            setups[i].destroy();
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
    }

    protected void cleanUpAfterRegression() {
    }
}

