/*
 * Decompiled with CFR 0.152.
 */
package adams.data.binning;

import adams.data.binning.Binnable;
import adams.data.binning.BinnableGroup;
import adams.data.binning.operation.Grouping;
import adams.data.binning.operation.Wrapping;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.Row;
import adams.ml.data.Dataset;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class BinnableDataset {
    public static List<Binnable<DataRow>> toBinnableUsingClass(Dataset data, int index) throws Exception {
        return Wrapping.wrap((Collection)data.rows(), (Wrapping.BinValueExtractor)new ClassValueBinValueExtractor(index));
    }

    public static List<Binnable<DataRow>> toBinnableUsingIndex(Dataset data) throws Exception {
        return Wrapping.wrap((Collection)data.rows(), (Wrapping.BinValueExtractor)new Wrapping.IndexedBinValueExtractor());
    }

    public static Dataset toDataset(List<Binnable<DataRow>> list) {
        Dataset result = (Dataset)((DataRow)list.get(0).getPayload()).getOwner().getHeader();
        for (DataRow row : Wrapping.unwrap(list)) {
            result.addRow().assign((Row)row);
        }
        return result;
    }

    public static class StringAttributeGroupExtractor
    implements Grouping.GroupExtractor<DataRow>,
    Serializable {
        private static final long serialVersionUID = -2381541290397169468L;
        protected int m_Index;
        protected String m_RegExp;
        protected String m_Group;

        public StringAttributeGroupExtractor(int index, String regExp, String group) {
            this.m_Index = index;
            this.m_RegExp = regExp;
            this.m_Group = group;
        }

        public String extractGroup(Binnable<DataRow> item) {
            return ((DataRow)item.getPayload()).getCell(this.m_Index).getContent().replace(this.m_RegExp, this.m_Group);
        }
    }

    public static class GroupedClassValueBinValueExtractor
    implements Wrapping.BinValueExtractor<BinnableGroup<DataRow>>,
    Serializable {
        private static final long serialVersionUID = -2287393293543008133L;
        protected int m_Index;

        public GroupedClassValueBinValueExtractor(int index) {
            this.m_Index = index;
        }

        public double extractBinValue(BinnableGroup<DataRow> object) {
            return ((DataRow)((Binnable)object.get().get(0)).getPayload()).getCell(this.m_Index).toDouble();
        }
    }

    public static class ClassValueBinValueExtractor
    implements Wrapping.BinValueExtractor<DataRow>,
    Serializable {
        private static final long serialVersionUID = -2287393293543008133L;
        protected int m_Index;

        public ClassValueBinValueExtractor(int index) {
            this.m_Index = index;
        }

        public double extractBinValue(DataRow object) {
            return object.getCell(this.m_Index).toDouble();
        }
    }
}

