/*
 * Decompiled with CFR 0.152.
 */
package adams.data.binning;

import adams.core.io.FileUtils;
import adams.data.binning.Binnable;
import adams.data.binning.operation.Grouping;
import adams.data.binning.operation.Wrapping;
import java.io.File;
import java.io.Serializable;
import java.util.List;

public class BinnableFiles {
    public static List<Binnable<String>> toBinnableUsingIndex(String[] data) throws Exception {
        return Wrapping.wrap((Object[])data, (Wrapping.BinValueExtractor)new Wrapping.IndexedBinValueExtractor());
    }

    public static List<Binnable<File>> toBinnableUsingIndex(File[] data) throws Exception {
        return Wrapping.wrap((Object[])data, (Wrapping.BinValueExtractor)new Wrapping.IndexedBinValueExtractor());
    }

    public static String[] toStringArray(List<Binnable<String>> list) {
        return Wrapping.unwrap(list).toArray(new String[0]);
    }

    public static File[] toFileArray(List<Binnable<File>> list) {
        return Wrapping.unwrap(list).toArray(new File[0]);
    }

    public static class FileGroupExtractor
    implements Grouping.GroupExtractor<String>,
    Serializable {
        private static final long serialVersionUID = -2456087580932522565L;
        protected boolean m_OnlyName;
        protected boolean m_RemoveExtension;
        protected String m_RegExp;
        protected String m_Group;

        public FileGroupExtractor(boolean onlyName, boolean removeExtension, String regExp, String group) {
            this.m_OnlyName = onlyName;
            this.m_RemoveExtension = removeExtension;
            this.m_RegExp = regExp;
            this.m_Group = group;
        }

        public String extractGroup(Binnable<String> item) {
            String value = (String)item.getPayload();
            if (this.m_RemoveExtension) {
                value = FileUtils.replaceExtension((String)value, (String)"");
            }
            if (this.m_OnlyName) {
                value = new File(value).getName();
            }
            return value.replaceAll(this.m_RegExp, this.m_Group);
        }
    }
}

