/*
 * Decompiled with CFR 0.152.
 */
package adams.data.splitgenerator.generic.randomization;

import adams.core.Randomizable;
import adams.data.binning.Binnable;
import adams.data.binning.operation.Randomize;
import adams.data.splitgenerator.generic.randomization.AbstractRandomization;
import java.util.List;
import java.util.Random;

public class DefaultRandomization
extends AbstractRandomization
implements Randomizable {
    private static final long serialVersionUID = -7659572567934958935L;
    protected long m_Seed;
    protected transient Random m_Random;

    public String globalInfo() {
        return "Randomizes the data using a random number generator initialized with the seed value.\nCalling reset() resets the number generator.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("seed", "seed", (Object)1L);
    }

    @Override
    public void reset() {
        super.reset();
        this.m_Random = null;
    }

    public void setSeed(long value) {
        this.m_Seed = value;
        this.reset();
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "The seed value to use for the random number generator.";
    }

    @Override
    protected <T> List<Binnable<T>> doRandomize(List<Binnable<T>> data) {
        if (this.m_Random == null) {
            this.m_Random = new Random(this.m_Seed);
        }
        return Randomize.randomizeData(data, (Random)this.m_Random);
    }
}

