/*
 * Decompiled with CFR 0.152.
 */
package adams.data.splitgenerator.generic.splitter;

import adams.data.binning.Binnable;
import adams.data.binning.operation.Split;
import adams.data.splitgenerator.generic.splitter.AbstractSplitter;
import com.github.fracpete.javautils.struct.Struct2;
import java.util.List;

public class DefaultSplitter
extends AbstractSplitter {
    private static final long serialVersionUID = 3058580709807088718L;
    protected double m_Percentage;

    public String globalInfo() {
        return "Splits the data using the specified percentage for training and rest for testing.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("percentage", "percentage", (Object)0.66, (Number)0.0, (Number)1.0);
    }

    public void setPercentage(double value) {
        if (this.getOptionManager().isValid("percentage", (Number)value)) {
            this.m_Percentage = value;
            this.reset();
        }
    }

    public double getPercentage() {
        return this.m_Percentage;
    }

    public String percentageTipText() {
        return "The percentage (0-1) to use for training.";
    }

    @Override
    protected <T> Struct2<List<Binnable<T>>, List<Binnable<T>>> doSplit(List<Binnable<T>> data) {
        return Split.split(data, (double)this.m_Percentage);
    }
}

