/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control.removeoutliers;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.statistics.StatUtils;
import adams.flow.control.removeoutliers.AbstractNumericOutlierDetector;
import java.util.HashSet;
import java.util.Set;

public class MeanAbsoluteError
extends AbstractNumericOutlierDetector {
    private static final long serialVersionUID = 6451004929042775852L;
    protected double m_Factor;

    public String globalInfo() {
        return "Mean absolute error (MAE) based detector.\nIf difference between actual/predicted is more than MAE * FACTOR, then the point gets flagged as outlier.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("factor", "factor", (Object)2.0, (Number)0.0, null);
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"factor", (Object)this.m_Factor, (String)"factor: ");
    }

    public void setFactor(double value) {
        this.m_Factor = value;
        this.reset();
    }

    public double getFactor() {
        return this.m_Factor;
    }

    public String factorTipText() {
        return "The factor which determines whether a value is an outlier.";
    }

    @Override
    protected Set<Integer> doDetect(SpreadSheet sheet, SpreadSheetColumnIndex actual, SpreadSheetColumnIndex predicted) {
        HashSet<Integer> result = new HashSet<Integer>();
        Number[] act = this.extractColumn(sheet, actual);
        Number[] pred = this.extractColumn(sheet, predicted);
        double[] diff = this.diff((Double[])act, (Double[])pred, false);
        double mae = StatUtils.mae((Number[])act, (Number[])pred);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("mae=" + mae);
        }
        for (int i = 0; i < diff.length; ++i) {
            if (!(Math.abs(diff[i]) > mae * this.m_Factor)) continue;
            result.add(i);
        }
        return result;
    }
}

