/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.data;

import adams.core.DateFormat;
import adams.core.exception.NotImplementedException;
import adams.data.SharedStringsTable;
import adams.data.io.output.CsvSpreadSheetWriter;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DataRowView;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.RowComparator;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetUtils;
import adams.ml.data.Dataset;
import adams.ml.data.DefaultDataset;
import gnu.trove.list.array.TIntArrayList;
import java.io.StringWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class DatasetView
implements Dataset {
    private static final long serialVersionUID = -3933080370817564099L;
    protected TIntArrayList m_Rows;
    protected int[] m_RowArray;
    protected TIntArrayList m_Columns;
    protected int[] m_ColumnArray;
    protected Dataset m_Dataset;
    protected HeaderRow m_HeaderRow;

    public DatasetView() {
        this(new DefaultDataset(), null, null);
    }

    public DatasetView(Dataset dataset, int[] rows, int[] columns) {
        if (dataset == null) {
            throw new IllegalArgumentException("Underlying spreadsheet cannot be null!");
        }
        this.m_Dataset = dataset;
        this.m_Rows = null;
        this.m_RowArray = rows;
        if (rows != null) {
            this.m_Rows = new TIntArrayList();
            this.m_Rows.addAll(rows);
        }
        this.m_Columns = null;
        this.m_ColumnArray = columns;
        if (columns != null) {
            this.m_Columns = new TIntArrayList();
            this.m_Columns.addAll(columns);
        }
        this.m_HeaderRow = null;
    }

    public void assign(SpreadSheet sheet) {
        if (sheet == null) {
            throw new IllegalArgumentException("Underlying dataset cannot be null!");
        }
        if (!(sheet instanceof Dataset)) {
            throw new IllegalArgumentException("Must be a dataset!");
        }
        this.m_Dataset = (Dataset)sheet;
        this.m_HeaderRow = null;
    }

    public void setDataRowClass(Class cls) {
        this.m_Dataset.setDataRowClass(cls);
    }

    public Class getDataRowClass() {
        return this.m_Dataset.getDataRowClass();
    }

    public SpreadSheet newInstance() {
        return this.m_Dataset.newInstance();
    }

    @Override
    public Dataset getClone() {
        return new DatasetView(this.m_Dataset.getClone(), this.m_RowArray, this.m_ColumnArray);
    }

    @Override
    public Dataset getHeader() {
        DefaultDataset result = new DefaultDataset();
        HeaderRow row = result.getHeaderRow();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            row.addCell(this.getHeaderRow().getCellKey(i)).setNative(this.getHeaderRow().getCell(i).getNative());
        }
        result.addComment(this.getComments());
        for (int index : this.getClassAttributeIndices()) {
            result.setClassAttribute(index, true);
        }
        return result;
    }

    @Override
    public int indexOfColumn(String name) {
        return this.getHeaderRow().indexOfContent(name);
    }

    protected int getActualRow(int rowIndex) {
        if (this.m_Rows == null) {
            return rowIndex;
        }
        return this.m_Rows.get(rowIndex);
    }

    protected int getActualColumn(int colIndex) {
        if (this.m_Columns == null) {
            return colIndex;
        }
        return this.m_Columns.get(colIndex);
    }

    protected String getActualRow(String rowKey) {
        String result = null;
        if (this.m_Rows == null) {
            result = rowKey;
        } else {
            int row = this.m_Dataset.getRowIndex(rowKey);
            if (this.m_Rows.contains(row)) {
                result = rowKey;
            }
        }
        return result;
    }

    protected String getActualColumn(String cellKey) {
        String result = null;
        if (this.m_Columns == null) {
            result = cellKey;
        } else {
            int cell = this.m_Dataset.getHeaderRow().indexOf(cellKey);
            if (this.m_Columns.contains(cell)) {
                result = cellKey;
            }
        }
        return result;
    }

    protected DataRowView wrap(DataRow row) {
        return new DataRowView((SpreadSheet)this, row, this.m_Columns == null ? null : this.m_Columns.toArray());
    }

    public DateFormat getDateFormat() {
        return this.m_Dataset.getDateFormat();
    }

    public DateFormat getDateTimeFormat() {
        return this.m_Dataset.getDateTimeFormat();
    }

    public DateFormat getDateTimeMsecFormat() {
        return this.m_Dataset.getDateTimeMsecFormat();
    }

    public DateFormat getTimeFormat() {
        return this.m_Dataset.getTimeFormat();
    }

    public DateFormat getTimeMsecFormat() {
        return this.m_Dataset.getTimeMsecFormat();
    }

    public NumberFormat getNumberFormat() {
        return this.m_Dataset.getNumberFormat();
    }

    public void setName(String value) {
        this.m_Dataset.setName(value);
    }

    public String getName() {
        return this.m_Dataset.getName();
    }

    public boolean hasName() {
        return this.m_Dataset.hasName();
    }

    public void addComment(String comment) {
        this.m_Dataset.addComment(comment);
    }

    public void addComment(List<String> comment) {
        this.m_Dataset.addComment(comment);
    }

    public List<String> getComments() {
        return this.m_Dataset.getComments();
    }

    public void clear() {
        throw new NotImplementedException();
    }

    public synchronized HeaderRow getHeaderRow() {
        HeaderRow result;
        if (this.m_Columns == null) {
            result = this.m_Dataset.getHeaderRow();
        } else if (this.m_HeaderRow == null) {
            result = new HeaderRow((SpreadSheet)this);
            HeaderRow other = this.m_Dataset.getHeaderRow();
            for (int i = 0; i < this.m_Columns.size(); ++i) {
                result.addCell(other.getCellKey(this.m_Columns.get(i))).assign(other.getCell(this.m_Columns.get(i)));
            }
            this.m_HeaderRow = result;
        } else {
            result = this.m_HeaderRow;
        }
        return result;
    }

    public String getColumnName(int colIndex) {
        return this.m_Dataset.getColumnName(this.getActualColumn(colIndex));
    }

    public List<String> getColumnNames() {
        ArrayList<String> result;
        if (this.m_Columns == null) {
            result = this.m_Dataset.getColumnNames();
        } else {
            result = new ArrayList<String>();
            for (int i = 0; i < this.m_Columns.size(); ++i) {
                result.add(this.m_Dataset.getColumnName(i));
            }
        }
        return result;
    }

    public boolean hasRow(int rowIndex) {
        return this.m_Dataset.hasRow(this.getActualRow(rowIndex));
    }

    public boolean hasRow(String rowKey) {
        return this.getActualRow(rowKey) != null;
    }

    public Cell newCell() {
        return this.m_Dataset.newCell();
    }

    public DataRow addRow() {
        throw new NotImplementedException();
    }

    public DataRow addRow(String rowKey) {
        throw new NotImplementedException();
    }

    public DataRow insertRow(int index) {
        throw new NotImplementedException();
    }

    public Row removeRow(int rowIndex) {
        throw new NotImplementedException();
    }

    public Row removeRow(String rowKey) {
        throw new NotImplementedException();
    }

    public void insertColumn(int columnIndex, String header) {
        throw new NotImplementedException();
    }

    public void insertColumn(int columnIndex, String header, String initial) {
        throw new NotImplementedException();
    }

    public void insertColumn(int columnIndex, String header, String initial, boolean forceString) {
        throw new NotImplementedException();
    }

    public boolean removeColumn(int columnIndex) {
        throw new NotImplementedException();
    }

    public boolean removeColumn(String columnKey) {
        throw new NotImplementedException();
    }

    public DataRow getRow(String rowKey) {
        DataRow row;
        if ((rowKey = this.getActualRow(rowKey)) != null && (row = this.m_Dataset.getRow(rowKey)) != null) {
            return this.wrap(row);
        }
        return null;
    }

    public DataRow getRow(int rowIndex) {
        return this.wrap(this.m_Dataset.getRow(this.getActualRow(rowIndex)));
    }

    public String getRowKey(int rowIndex) {
        return this.m_Dataset.getRowKey(this.getActualRow(rowIndex));
    }

    public int getRowIndex(String rowKey) {
        int result = -1;
        int row = this.m_Dataset.getRowIndex(rowKey);
        if (this.m_Rows == null) {
            result = row;
        } else if (this.m_Rows.contains(row)) {
            result = row;
        }
        return result;
    }

    public int getCellIndex(String cellKey) {
        int result = -1;
        int col = this.m_Dataset.getCellIndex(cellKey);
        if (this.m_Columns == null) {
            result = col;
        } else if (this.m_Columns.contains(col)) {
            result = col;
        }
        return result;
    }

    public boolean hasCell(int rowIndex, int columnIndex) {
        DataRow row = this.getRow(rowIndex);
        return row != null && row.hasCell(columnIndex);
    }

    public Cell getCell(int rowIndex, int columnIndex) {
        DataRow row = this.getRow(rowIndex);
        if (row != null) {
            return row.getCell(columnIndex);
        }
        return null;
    }

    public String getCellPosition(String rowKey, String cellKey) {
        if (this.getRowIndex(rowKey) == -1 || this.getCellIndex(cellKey) == -1) {
            return null;
        }
        return SpreadSheetUtils.getCellPosition((int)(this.getRowIndex(rowKey) + 1), (int)this.getCellIndex(cellKey));
    }

    public Collection<String> rowKeys() {
        ArrayList<String> result;
        if (this.m_Rows == null) {
            result = this.m_Dataset.rowKeys();
        } else {
            result = new ArrayList<String>();
            for (int i = 0; i < this.m_Rows.size(); ++i) {
                result.add(this.m_Dataset.getRowKey(this.m_Rows.get(i)));
            }
        }
        return result;
    }

    public Collection<DataRow> rows() {
        ArrayList<DataRow> result = new ArrayList<DataRow>();
        if (this.m_Rows == null) {
            for (DataRow row : this.m_Dataset.rows()) {
                result.add((DataRow)this.wrap(row));
            }
        } else {
            for (int i = 0; i < this.m_Rows.size(); ++i) {
                result.add((DataRow)this.wrap(this.m_Dataset.getRow(this.m_Rows.get(i))));
            }
        }
        return result;
    }

    public void sortRowKeys() {
        throw new NotImplementedException();
    }

    public void sortRowKeys(Comparator<String> comp) {
        throw new NotImplementedException();
    }

    public void sort(int index, boolean asc) {
        throw new NotImplementedException();
    }

    public void sort(RowComparator comp) {
        throw new NotImplementedException();
    }

    public void sort(RowComparator comp, boolean unique) {
        throw new NotImplementedException();
    }

    public int getColumnCount() {
        if (this.m_Columns == null) {
            return this.m_Dataset.getColumnCount();
        }
        return this.m_Columns.size();
    }

    public int getRowCount() {
        if (this.m_Rows == null) {
            return this.m_Dataset.getRowCount();
        }
        return this.m_Rows.size();
    }

    public boolean isNumeric(int columnIndex) {
        return this.m_Dataset.isNumeric(this.getActualColumn(columnIndex));
    }

    public boolean isNumeric(int columnIndex, boolean allowMissing) {
        return this.m_Dataset.isNumeric(this.getActualColumn(columnIndex), allowMissing);
    }

    public boolean isContentType(int columnIndex, Cell.ContentType type) {
        return this.m_Dataset.isContentType(this.getActualColumn(columnIndex), type);
    }

    public Cell.ContentType getContentType(int columnIndex) {
        return this.m_Dataset.getContentType(this.getActualColumn(columnIndex));
    }

    public Collection<Cell.ContentType> getContentTypes(int columnIndex) {
        return this.m_Dataset.getContentTypes(this.getActualColumn(columnIndex));
    }

    public List<String> getCellValues(String colKey) {
        if ((colKey = this.getActualColumn(colKey)) != null) {
            return this.m_Dataset.getCellValues(colKey);
        }
        return new ArrayList<String>();
    }

    public List<String> getCellValues(int colIndex) {
        return this.m_Dataset.getCellValues(this.getActualColumn(colIndex));
    }

    public String equalsHeader(SpreadSheet other) {
        String result = null;
        if (other == null) {
            return result;
        }
        HeaderRow header = this.getHeaderRow();
        HeaderRow otherHeader = other.getHeaderRow();
        if (header.getCellCount() != otherHeader.getCellCount()) {
            result = "Number of columns differ: " + header.getCellCount() + " != " + otherHeader.getCellCount();
        }
        if (result == null) {
            for (int i = 0; i < header.getCellCount(); ++i) {
                if (header.getCell(i).getContent().equals(otherHeader.getCell(i).getContent())) continue;
                result = "Column header #" + (i + 1) + " differs: " + header.getCell(i).getContent() + " != " + otherHeader.getCell(i).getContent();
                break;
            }
        }
        return result;
    }

    public boolean removeMissing() {
        throw new NotImplementedException();
    }

    public SharedStringsTable getSharedStringsTable() {
        return this.m_Dataset.getSharedStringsTable();
    }

    public void setDateLenient(boolean value) {
        this.m_Dataset.setDateLenient(value);
    }

    public boolean isDateLenient() {
        return this.m_Dataset.isDateLenient();
    }

    public void setDateTimeLenient(boolean value) {
        this.m_Dataset.setDateTimeLenient(value);
    }

    public boolean isDateTimeLenient() {
        return this.m_Dataset.isDateTimeLenient();
    }

    public void setDateTimeMsecLenient(boolean value) {
        this.m_Dataset.setDateTimeMsecLenient(value);
    }

    public boolean isDateTimeMsecLenient() {
        return this.m_Dataset.isDateTimeMsecLenient();
    }

    public void setTimeLenient(boolean value) {
        this.m_Dataset.setTimeLenient(value);
    }

    public boolean isTimeLenient() {
        return this.m_Dataset.isTimeLenient();
    }

    public void setTimeMsecLenient(boolean value) {
        this.m_Dataset.setTimeMsecLenient(value);
    }

    public boolean isTimeMsecLenient() {
        return this.m_Dataset.isTimeMsecLenient();
    }

    public void setTimeZone(TimeZone value) {
        this.m_Dataset.setTimeZone(value);
    }

    public TimeZone getTimeZone() {
        return this.m_Dataset.getTimeZone();
    }

    public void setLocale(Locale value) {
        this.m_Dataset.setLocale(value);
    }

    public Locale getLocale() {
        return this.m_Dataset.getLocale();
    }

    public void calculate() {
        this.m_Dataset.calculate();
    }

    public void mergeWith(SpreadSheet other) {
        throw new NotImplementedException();
    }

    public Dataset getDataset() {
        return this.m_Dataset;
    }

    @Override
    public void removeClassAttributes() {
        throw new NotImplementedException();
    }

    @Override
    public boolean isClassAttribute(String colKey) {
        if (colKey == null || this.getActualColumn(colKey) == null) {
            return false;
        }
        return this.m_Dataset.isClassAttribute(this.getActualColumn(colKey));
    }

    @Override
    public boolean isClassAttribute(int colIndex) {
        if (colIndex > -1) {
            return this.isClassAttribute(this.m_HeaderRow.getCellKey(colIndex));
        }
        return false;
    }

    @Override
    public boolean isClassAttributeByName(String name) {
        return this.isClassAttribute(this.getHeaderRow().indexOfContent(name));
    }

    @Override
    public boolean setClassAttribute(String colKey, boolean isClass) {
        throw new NotImplementedException();
    }

    @Override
    public boolean setClassAttribute(int colIndex, boolean isClass) {
        throw new NotImplementedException();
    }

    @Override
    public boolean setClassAttributeByName(String name, boolean isClass) {
        throw new NotImplementedException();
    }

    @Override
    public String[] getClassAttributeKeys() {
        ArrayList<String> result = new ArrayList<String>();
        for (String key : this.m_Dataset.getClassAttributeKeys()) {
            if ((key = this.getActualColumn(key)) == null) continue;
            result.add(key);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String[] getClassAttributeNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (int index : this.getClassAttributeIndices()) {
            result.add(this.getColumnName(index));
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public int[] getClassAttributeIndices() {
        String[] keys = this.getClassAttributeKeys();
        int[] result = new int[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            result[i] = this.getHeaderRow().indexOf(keys[i]);
        }
        Arrays.sort(result);
        return result;
    }

    @Override
    public SpreadSheet getInputs() {
        int i;
        if (this.getClassAttributeKeys().length == 0) {
            return this.getClone();
        }
        if (this.getClassAttributeKeys().length == this.getColumnCount()) {
            return null;
        }
        TIntArrayList indices = new TIntArrayList();
        for (i = 0; i < this.getColumnCount(); ++i) {
            if (this.isClassAttribute(i)) continue;
            indices.add(i);
        }
        SpreadSheet result = this.newInstance();
        HeaderRow newRow = result.getHeaderRow();
        for (i = 0; i < indices.size(); ++i) {
            newRow.addCell("" + i).assign(this.getHeaderRow().getCell(indices.get(i)));
        }
        for (Row row : this.rows()) {
            newRow = result.addRow();
            for (i = 0; i < indices.size(); ++i) {
                if (!row.hasCell(indices.get(i))) continue;
                newRow.addCell(i).assign(row.getCell(indices.get(i)));
            }
        }
        return result;
    }

    @Override
    public SpreadSheet getOutputs() {
        int i;
        if (this.getClassAttributeKeys().length == 0) {
            return null;
        }
        if (this.getClassAttributeKeys().length == this.getColumnCount()) {
            return this.getClone();
        }
        TIntArrayList indices = new TIntArrayList();
        for (i = 0; i < this.getColumnCount(); ++i) {
            if (!this.isClassAttribute(i)) continue;
            indices.add(i);
        }
        SpreadSheet result = this.newInstance();
        HeaderRow newRow = result.getHeaderRow();
        for (i = 0; i < indices.size(); ++i) {
            newRow.addCell("" + i).assign(this.getHeaderRow().getCell(indices.get(i)));
        }
        for (Row row : this.rows()) {
            newRow = result.addRow();
            for (i = 0; i < indices.size(); ++i) {
                if (!row.hasCell(indices.get(i))) continue;
                newRow.addCell(i).assign(row.getCell(indices.get(i)));
            }
        }
        return result;
    }

    public Object[][] toMatrix() {
        int i;
        Object[][] result = new Object[this.getRowCount() + 1][this.getColumnCount()];
        HeaderRow row = this.getHeaderRow();
        for (i = 0; i < this.getColumnCount(); ++i) {
            if (row.getCell(i).isMissing()) continue;
            result[0][i] = row.getCell(i).getContent();
        }
        for (int n = 0; n < this.getRowCount(); ++n) {
            row = this.getRow(n);
            for (i = 0; i < this.getColumnCount(); ++i) {
                Cell cell;
                String key = this.getHeaderRow().getCellKey(i);
                if (!row.hasCell(key) || (cell = row.getCell(i)).isMissing()) continue;
                result[n + 1][i] = cell.isNumeric() ? row.getCell(i).toDouble() : row.getCell(i).getContent();
            }
        }
        return result;
    }

    public String toString() {
        StringWriter swriter = new StringWriter();
        CsvSpreadSheetWriter cwriter = new CsvSpreadSheetWriter();
        cwriter.write((SpreadSheet)this, (Writer)swriter);
        return swriter.toString();
    }

    public DatasetView toView(int[] rows, int[] columns) {
        return new DatasetView(this, rows, columns);
    }
}

