/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.evaluation;

import adams.data.binning.BinnableDataset;
import adams.data.splitgenerator.generic.randomization.AbstractRandomization;
import adams.data.splitgenerator.generic.randomization.DefaultRandomization;
import adams.data.splitgenerator.generic.randomization.PassThrough;
import adams.data.splitgenerator.generic.randomsplit.RandomSplitGenerator;
import adams.data.splitgenerator.generic.randomsplit.SplitPair;
import adams.data.splitgenerator.generic.splitter.DefaultSplitter;
import adams.flow.container.TrainTestSetContainer;
import adams.ml.data.Dataset;
import adams.ml.data.DatasetView;
import adams.ml.evaluation.AbstractSplitGenerator;
import java.util.List;

public class DefaultRandomSplitGenerator
extends AbstractSplitGenerator
implements adams.data.splitgenerator.RandomSplitGenerator<Dataset, TrainTestSetContainer> {
    private static final long serialVersionUID = -4813006743965500489L;
    protected double m_Percentage;
    protected boolean m_PreserveOrder;
    protected boolean m_Generated;
    protected RandomSplitGenerator m_Generator;

    public DefaultRandomSplitGenerator() {
    }

    public DefaultRandomSplitGenerator(Dataset data, long seed, double percentage) {
        this.setData(data);
        this.setSeed(seed);
        this.setPercentage(percentage);
        this.setPreserveOrder(false);
    }

    public DefaultRandomSplitGenerator(Dataset data, double percentage) {
        this.setData(data);
        this.setSeed(-1L);
        this.setPercentage(percentage);
        this.setPreserveOrder(true);
    }

    public DefaultRandomSplitGenerator(Dataset data, long seed, double percentage, boolean preserveOrder) {
        this.setData(data);
        this.setSeed(seed);
        this.setPercentage(percentage);
        this.setPreserveOrder(preserveOrder);
    }

    public String globalInfo() {
        return "Performs a percentage split, either randomized or with the order preserved.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("percentage", "percentage", (Object)0.66, (Number)0.0, (Number)1.0);
        this.m_OptionManager.add("preserve-order", "preserveOrder", (Object)false);
    }

    @Override
    public void setPercentage(double value) {
        if (this.getOptionManager().isValid("percentage", (Number)value)) {
            this.m_Percentage = value;
            this.reset();
        }
    }

    @Override
    public double getPercentage() {
        return this.m_Percentage;
    }

    public String percentageTipText() {
        return "The percentage to use for training (0-1).";
    }

    @Override
    public void setPreserveOrder(boolean value) {
        this.m_PreserveOrder = value;
        this.reset();
    }

    @Override
    public boolean getPreserveOrder() {
        return this.m_PreserveOrder;
    }

    public String preserveOrderTipText() {
        return "If enabled, the order in the data is preserved in the split.";
    }

    @Override
    protected boolean canRandomize() {
        return !this.m_PreserveOrder;
    }

    @Override
    protected void doInitializeIterator() {
        AbstractRandomization rand;
        if (this.m_Data == null) {
            throw new IllegalStateException("No data available!");
        }
        this.m_Generator = new RandomSplitGenerator();
        if (this.canRandomize()) {
            rand = new DefaultRandomization();
            ((DefaultRandomization)rand).setSeed(this.m_Seed);
            this.m_Generator.setRandomization(rand);
        } else {
            rand = new PassThrough();
            this.m_Generator.setRandomization(rand);
        }
        DefaultSplitter splitter = new DefaultSplitter();
        splitter.setPercentage(this.m_Percentage);
        this.m_Generator.setSplitter(splitter);
        this.m_Generated = false;
    }

    @Override
    protected boolean checkNext() {
        return !this.m_Generated;
    }

    @Override
    protected TrainTestSetContainer createNext() {
        Dataset testSet;
        Dataset trainSet;
        List binnedData;
        this.m_Generated = true;
        try {
            binnedData = BinnableDataset.toBinnableUsingIndex(this.m_Data);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create binnable Dataset!", e);
        }
        SplitPair splitPair = this.m_Generator.generate(binnedData);
        int[] trainRows = splitPair.getTrain().getOriginalIndices().toArray();
        int[] testRows = splitPair.getTest().getOriginalIndices().toArray();
        if (this.m_UseViews) {
            trainSet = new DatasetView(this.m_Data, trainRows, null);
            testSet = new DatasetView(this.m_Data, testRows, null);
        } else {
            trainSet = BinnableDataset.toDataset(splitPair.getTrain().getData());
            testSet = BinnableDataset.toDataset(splitPair.getTest().getData());
        }
        TrainTestSetContainer result = new TrainTestSetContainer(trainSet, testSet, this.m_Seed, null, null, trainRows, testRows);
        return result;
    }

    @Override
    public String toString() {
        return super.toString() + ", percentage=" + this.m_Percentage;
    }
}

