/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.preprocessing.unsupervised;

import adams.ml.capabilities.Capabilities;
import adams.ml.data.Dataset;
import adams.ml.preprocessing.AbstractBatchFilter;
import adams.ml.preprocessing.StreamFilter;
import adams.ml.preprocessing.unsupervised.PassThrough;

public class MultiBatch
extends AbstractBatchFilter {
    private static final long serialVersionUID = 8129384772744387384L;
    protected StreamFilter[] m_Filters;

    public String globalInfo() {
        return "Applies the specified filters sequentially.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("filter", "filters", (Object)new StreamFilter[]{new PassThrough()});
    }

    public void setFilters(StreamFilter[] value) {
        this.m_Filters = value;
        this.reset();
    }

    public StreamFilter[] getFilters() {
        return this.m_Filters;
    }

    public String filtersTipText() {
        return "The filters to apply sequentially.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result;
        if (this.m_Filters.length == 0) {
            result = new Capabilities(this);
            result.enableAllClass();
            result.enableAll();
        } else {
            result = this.m_Filters[0].getCapabilities();
            result.setOwner(this);
        }
        return result;
    }

    @Override
    protected void doInitFilter(Dataset data) throws Exception {
        if (this.m_Filters.length == 0) {
            throw new Exception("No filters specified!");
        }
    }

    @Override
    protected Dataset initOutputFormat(Dataset data) throws Exception {
        return this.m_Filters[0].getOutputFormat();
    }

    @Override
    protected Dataset doFilter(Dataset data) throws Exception {
        Dataset result = data;
        for (int i = 0; i < this.m_Filters.length; ++i) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Applying filter #" + (i + 1));
            }
            result = this.m_Filters[i].filter(result);
        }
        return result;
    }
}

