/*
 * Decompiled with CFR 0.152.
 */
package adams.data.splitgenerator.generic.stratification;

import adams.core.option.AbstractOptionHandler;
import adams.data.binning.Binnable;
import adams.data.splitgenerator.generic.stratification.Stratification;
import java.util.List;

public abstract class AbstractStratification
extends AbstractOptionHandler
implements Stratification {
    private static final long serialVersionUID = -5619683133352175979L;

    @Override
    public void reset() {
        super.reset();
    }

    protected <T> String check(List<Binnable<T>> data, int folds) {
        if (data == null || data.size() == 0) {
            return "No data provided!";
        }
        if (data.size() < folds) {
            return "You cannot have more folds than data: " + data.size() + " < " + folds;
        }
        return null;
    }

    protected abstract <T> List<Binnable<T>> doStratify(List<Binnable<T>> var1, int var2);

    @Override
    public <T> List<Binnable<T>> stratify(List<Binnable<T>> data, int folds) {
        String msg = this.check(data, folds);
        if (msg != null) {
            throw new IllegalStateException(msg);
        }
        return this.doStratify(data, folds);
    }
}

