/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control.removeoutliers;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.statistics.StatUtils;
import adams.flow.control.removeoutliers.AbstractNumericOutlierDetector;
import java.util.HashSet;
import java.util.Set;

public class IQR
extends AbstractNumericOutlierDetector {
    private static final long serialVersionUID = 6451004929042775852L;
    protected double m_Factor;
    protected boolean m_UseRelative;

    public String globalInfo() {
        return "Interquartile range based detector.\nIf difference between actual/predicted is more than the factor of standard deviations away from the quartial 0.25/0.75, then the point gets flagged as outlier.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("factor", "factor", (Object)3.0, (Number)0.0, null);
        this.m_OptionManager.add("use-relative", "useRelative", (Object)false);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"factor", (Object)this.m_Factor, (String)"factor: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"useRelative", (boolean)this.m_UseRelative, (String)"relative", (String)", ");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    public void setFactor(double value) {
        this.m_Factor = value;
        this.reset();
    }

    public double getFactor() {
        return this.m_Factor;
    }

    public String factorTipText() {
        return "The factor which determines whether a value is an outlier.";
    }

    public void setUseRelative(boolean value) {
        this.m_UseRelative = value;
        this.reset();
    }

    public boolean getUseRelative() {
        return this.m_UseRelative;
    }

    public String useRelativeTipText() {
        return "If enabled, relative values (divided by actual) are used instead of absolute ones.";
    }

    @Override
    protected Set<Integer> doDetect(SpreadSheet sheet, SpreadSheetColumnIndex actual, SpreadSheetColumnIndex predicted) {
        HashSet<Integer> result = new HashSet<Integer>();
        Double[] act = this.extractColumn(sheet, actual);
        Double[] pred = this.extractColumn(sheet, predicted);
        double[] diff = this.diff(act, pred, this.m_UseRelative);
        double iqr1 = StatUtils.quartile((double[])diff, (double)0.25);
        double iqr3 = StatUtils.quartile((double[])diff, (double)0.75);
        double iqr = iqr3 - iqr1;
        if (this.isLoggingEnabled()) {
            this.getLogger().info("iqr1=" + iqr1 + ", iqr3=" + iqr3 + ", iqr=" + iqr);
        }
        for (int i = 0; i < diff.length; ++i) {
            if (diff[i] > iqr3 + iqr * this.m_Factor) {
                result.add(i);
                continue;
            }
            if (!(diff[i] < iqr1 - iqr * this.m_Factor)) continue;
            result.add(i);
        }
        return result;
    }
}

