/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.indexedsplitsrunsgenerator;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.Randomizable;
import adams.core.option.OptionHandler;
import adams.data.binning.BinnableDataset;
import adams.data.indexedsplits.IndexedSplit;
import adams.data.indexedsplits.IndexedSplits;
import adams.data.indexedsplits.IndexedSplitsRun;
import adams.data.indexedsplits.IndexedSplitsRuns;
import adams.data.indexedsplits.SplitIndices;
import adams.data.splitgenerator.generic.randomization.AbstractRandomization;
import adams.data.splitgenerator.generic.randomization.DefaultRandomization;
import adams.data.splitgenerator.generic.randomization.PassThrough;
import adams.data.splitgenerator.generic.randomsplit.RandomSplitGenerator;
import adams.data.splitgenerator.generic.randomsplit.SplitPair;
import adams.data.splitgenerator.generic.splitter.DefaultSplitter;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.transformer.indexedsplitsrunsgenerator.AbstractSpreadSheetIndexedSplitsRunsGenerator;
import java.util.List;

public class SpreadSheetRandomSplitGenerator
extends AbstractSpreadSheetIndexedSplitsRunsGenerator
implements Randomizable {
    private static final long serialVersionUID = -845552507613381226L;
    protected double m_Percentage;
    protected long m_Seed;
    protected boolean m_PreserveOrder;

    public String globalInfo() {
        return "Random split generator that works on spreadsheets.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("percentage", "percentage", (Object)0.66, (Number)0.0, (Number)1.0);
        this.m_OptionManager.add("seed", "seed", (Object)1L);
        this.m_OptionManager.add("preserve-order", "preserveOrder", (Object)false);
    }

    public void setPercentage(double value) {
        if (this.getOptionManager().isValid("percentage", (Number)value)) {
            this.m_Percentage = value;
            this.reset();
        }
    }

    public double getPercentage() {
        return this.m_Percentage;
    }

    public String percentageTipText() {
        return "The percentage to use for training (0-1).";
    }

    public void setSeed(long value) {
        this.m_Seed = value;
        this.reset();
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "The seed value for the random number generator.";
    }

    public void setPreserveOrder(boolean value) {
        this.m_PreserveOrder = value;
        this.reset();
    }

    public boolean getPreserveOrder() {
        return this.m_PreserveOrder;
    }

    public String preserveOrderTipText() {
        return "If enabled, the order in the data is preserved in the split.";
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"percentage", (Object)this.m_Percentage, (String)", percentage: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"preserveOrder", (Object)(this.m_PreserveOrder ? "preserve order" : "randomize"), (String)", ");
        if (!this.m_PreserveOrder) {
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"seed", (Object)this.m_Seed, (String)", seed: ");
        }
        return result;
    }

    protected IndexedSplitsRuns doGenerate(Object data, MessageCollection errors) {
        List binnedData;
        AbstractRandomization rand;
        SpreadSheet sheet = (SpreadSheet)data;
        RandomSplitGenerator generator = new RandomSplitGenerator();
        if (this.m_PreserveOrder) {
            rand = new PassThrough();
            generator.setRandomization(rand);
        } else {
            rand = new DefaultRandomization();
            ((DefaultRandomization)rand).setSeed(this.m_Seed);
            generator.setRandomization(rand);
        }
        DefaultSplitter splitter = new DefaultSplitter();
        splitter.setPercentage(this.m_Percentage);
        generator.setSplitter(splitter);
        try {
            binnedData = BinnableDataset.toBinnableUsingIndex(sheet);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create binnable spreadsheet!", e);
        }
        SplitPair splitPair = generator.generate(binnedData);
        int[] trainRows = splitPair.getTrain().getOriginalIndices().toArray();
        int[] testRows = splitPair.getTest().getOriginalIndices().toArray();
        IndexedSplit indexedSplit = new IndexedSplit(0);
        indexedSplit.add(new SplitIndices("train", trainRows));
        indexedSplit.add(new SplitIndices("test", testRows));
        IndexedSplits indexedSplits = new IndexedSplits();
        indexedSplits.add((Object)indexedSplit);
        IndexedSplitsRun indexedSplitsRun = new IndexedSplitsRun(0, indexedSplits);
        IndexedSplitsRuns result = new IndexedSplitsRuns();
        result.add((Object)indexedSplitsRun);
        return result;
    }
}

