/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.summarystatistics;

import adams.flow.transformer.summarystatistics.AbstractNumericSummaryStatistic;
import adams.flow.transformer.summarystatistics.PredictionHelper;

public class MeanAbsoluteError
extends AbstractNumericSummaryStatistic {
    private static final long serialVersionUID = 96425796158048162L;

    public String globalInfo() {
        return "Calculates the MAE (mean absolute error).";
    }

    @Override
    public String[] getNames() {
        return new String[]{"MAE"};
    }

    @Override
    protected double[] doCalculate() {
        double sum = 0.0;
        double[][] numFiltered = PredictionHelper.filterMissing(this.m_NumericActual, this.m_NumericPredicted);
        double[] numAct = numFiltered[0];
        double[] numPred = numFiltered[1];
        int total = numAct.length;
        for (int i = 0; i < numAct.length; ++i) {
            sum += Math.abs(numPred[i] - numAct[i]);
        }
        return new double[]{sum / (double)total};
    }
}

