/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core.spreadsheettable;

import adams.data.spreadsheet.Cell;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.spreadsheettable.AbstractCellRenderingCustomizer;
import adams.gui.visualization.core.AbstractColorGradientGenerator;
import adams.gui.visualization.core.ConfusionMatrixColorGenerator;
import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;

public class ConfusionMatrixCellRenderingCustomizer
extends AbstractCellRenderingCustomizer {
    private static final long serialVersionUID = -5036118898148310042L;
    protected Color m_Highlight;
    protected boolean m_ValueBasedBackground;
    protected AbstractColorGradientGenerator m_BackgroundColorGenerator;
    protected transient Map<Integer, Color> m_Colors;

    public String globalInfo() {
        return "Uses the specified color to highlight the cells on the diagonal.\nIt also possible to color in the backgrounds of the non-diagonal cells based on their value.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("highlight", "highlight", (Object)new Color(192, 192, 192, 128));
        this.m_OptionManager.add("value-based-background", "valueBasedBackground", (Object)false);
        this.m_OptionManager.add("background-color-generator", "backgroundColorGenerator", (Object)new ConfusionMatrixColorGenerator());
    }

    protected void reset() {
        super.reset();
        this.m_Colors = null;
    }

    public void setHighlight(Color value) {
        this.m_Highlight = value;
        this.reset();
    }

    public Color getHighlight() {
        return this.m_Highlight;
    }

    public String highlightTipText() {
        return "The color to use as background for the diagonal cells.";
    }

    public void setValueBasedBackground(boolean value) {
        this.m_ValueBasedBackground = value;
        this.reset();
    }

    public boolean getValueBasedBackground() {
        return this.m_ValueBasedBackground;
    }

    public String valueBasedBackgroundTipText() {
        return "If enabled, the background of the cells gets colored in based on their value.";
    }

    public void setBackgroundColorGenerator(AbstractColorGradientGenerator value) {
        this.m_BackgroundColorGenerator = value;
        this.reset();
    }

    public AbstractColorGradientGenerator getBackgroundColorGenerator() {
        return this.m_BackgroundColorGenerator;
    }

    public String backgroundColorGeneratorTipText() {
        return "The color generator to use for obtaining the colors for coloring in the backgrounds.";
    }

    public Font getFont(SpreadSheetTable table, boolean isSelected, boolean hasFocus, int row, int column, Cell cell, Font defFont) {
        Font result = super.getFont(table, isSelected, hasFocus, row, column, cell, defFont);
        if (column == 0 && table.getShowRowColumn()) {
            return result;
        }
        if (--column == 0) {
            return result.deriveFont(1);
        }
        return result;
    }

    protected synchronized void initColors() {
        if (this.m_Colors != null) {
            return;
        }
        this.m_Colors = new HashMap<Integer, Color>();
        Color[] colors = this.m_BackgroundColorGenerator.generate();
        for (int i = 0; i < colors.length; ++i) {
            this.m_Colors.put(i, colors[i]);
        }
    }

    public Color getBackgroundColor(SpreadSheetTable table, boolean isSelected, boolean hasFocus, int row, int column, Cell cell, Color defColor) {
        double max;
        double[] minMax;
        double min;
        this.initColors();
        Color result = super.getBackgroundColor(table, isSelected, hasFocus, row, column, cell, defColor);
        int actCol = column;
        int actRow = row;
        if (actCol == 0 && table.getShowRowColumn()) {
            return result;
        }
        if (table.getShowRowColumn()) {
            --actCol;
        }
        if (actCol == 0) {
            result = table.getTableHeader().getBackground();
            if (isSelected) {
                result = result.darker();
            }
            return result;
        }
        if (--actCol == (actRow = table.getActualRow(actRow))) {
            result = isSelected ? this.m_Highlight.darker() : this.m_Highlight;
        } else if (this.m_ValueBasedBackground && (min = (minMax = this.getMinMax(table, null, null))[0]) < (max = minMax[1])) {
            Cell spCell = table.getCellAt(row, column);
            if (spCell != null && spCell.isNumeric()) {
                double value = spCell.toDouble();
                int index = (int)((value - min) / (max - min) * (double)(this.m_Colors.size() - 1));
                result = this.m_Colors.get(index);
            } else {
                result = defColor;
            }
            if (isSelected) {
                result = result.darker();
            }
        }
        return result;
    }

    public int getHorizontalAlignment(SpreadSheetTable table, boolean isSelected, boolean hasFocus, int row, int column, Cell cell, int defAlign) {
        int result = super.getHorizontalAlignment(table, isSelected, hasFocus, row, column, cell, defAlign);
        if (column == 0 && table.getShowRowColumn()) {
            return result;
        }
        if (table.getShowRowColumn()) {
            --column;
        }
        if (column == 0) {
            return 2;
        }
        return result;
    }
}

