/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.model.classification;

import adams.core.DateUtils;
import adams.core.logging.LoggingHelper;
import adams.core.option.AbstractOptionHandler;
import adams.ml.capabilities.Capabilities;
import adams.ml.capabilities.CapabilitiesHelper;
import adams.ml.capabilities.Capability;
import adams.ml.data.Dataset;
import adams.ml.model.classification.MultiTargetClassificationModel;
import adams.ml.model.classification.MultiTargetClassifier;
import java.util.Date;

public abstract class AbstractMultiTargetClassifier
extends AbstractOptionHandler
implements MultiTargetClassifier {
    private static final long serialVersionUID = 1493597879425680024L;
    protected boolean m_StrictCapabilities;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("strict-capabilities", "strictCapabilities", (Object)false);
    }

    public void setStrictCapabilities(boolean value) {
        this.m_StrictCapabilities = value;
        this.reset();
    }

    public boolean getStrictCapabilities() {
        return this.m_StrictCapabilities;
    }

    public String strictCapabilitiesTipText() {
        return "If enabled, a strict capabilities test is performed; otherwise, it is attempted to adjust the data to fit the algorithm's capabilities.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities(this);
        result.setMinClassColumns(1);
        result.setMaxClassColumns(1);
        result.enable(Capability.CATEGORICAL_CLASS);
        return result;
    }

    @Override
    public String handles(Dataset data, boolean strict) {
        String result = CapabilitiesHelper.handles(this.getCapabilities(), data);
        if (!strict && result != null) {
            try {
                Dataset adjusted = CapabilitiesHelper.adjust(data, this.getCapabilities());
                result = CapabilitiesHelper.handles(this.getCapabilities(), adjusted);
            }
            catch (Exception e) {
                result = result + "\nAdjusting of dataset failed with: " + LoggingHelper.throwableToString((Throwable)e);
            }
        }
        return result;
    }

    protected Dataset check(Dataset data) throws Exception {
        String msg = this.handles(data, this.m_StrictCapabilities);
        if (msg != null) {
            throw new Exception("Capabilities check failed: " + msg);
        }
        if (!this.m_StrictCapabilities) {
            return CapabilitiesHelper.adjust(data, this.getCapabilities());
        }
        return data;
    }

    protected abstract MultiTargetClassificationModel doBuildModel(Dataset var1) throws Exception;

    @Override
    public MultiTargetClassificationModel buildModel(Dataset data) throws Exception {
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Performing checks");
        }
        data = this.check(data);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Checks passed");
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("Build start: " + DateUtils.getTimestampFormatterMsecs().format(new Date()));
        }
        MultiTargetClassificationModel result = this.doBuildModel(data);
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("Build end: " + DateUtils.getTimestampFormatterMsecs().format(new Date()));
        }
        return result;
    }
}

