/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.preprocessing;

import adams.core.base.BaseRegExp;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.ml.capabilities.Capabilities;
import adams.ml.capabilities.CapabilitiesHelper;
import adams.ml.data.Dataset;
import adams.ml.preprocessing.AbstractFilter;
import adams.ml.preprocessing.ColumnSubset;
import adams.ml.preprocessing.ColumnSubsetFilter;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;

public abstract class AbstractColumnSubsetFilter
extends AbstractFilter
implements ColumnSubsetFilter {
    private static final long serialVersionUID = -7832232995060446187L;
    protected ColumnSubset m_ColumnSubset;
    protected SpreadSheetColumnRange m_ColRange;
    protected BaseRegExp m_ColRegExp;
    protected boolean m_DropOtherColumns;
    protected TIntList m_DataColumns;
    protected TIntList m_ClassColumns;
    protected TIntList m_OtherColumns;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("column-subset", "columnSubset", (Object)ColumnSubset.RANGE);
        this.m_OptionManager.add("col-range", "colRange", (Object)new SpreadSheetColumnRange("first-last"));
        this.m_OptionManager.add("col-regexp", "colRegExp", (Object)new BaseRegExp(".*"));
        this.m_OptionManager.add("drop-other-columns", "dropOtherColumns", (Object)false);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_DataColumns = new TIntArrayList();
        this.m_ClassColumns = new TIntArrayList();
        this.m_OtherColumns = new TIntArrayList();
    }

    @Override
    public void setColumnSubset(ColumnSubset value) {
        this.m_ColumnSubset = value;
        this.reset();
    }

    @Override
    public ColumnSubset getColumnSubset() {
        return this.m_ColumnSubset;
    }

    @Override
    public String columnSubsetTipText() {
        return "Defines how to determine the columns to use for filtering.";
    }

    @Override
    public void setColRange(SpreadSheetColumnRange value) {
        this.m_ColRange = value;
        this.reset();
    }

    @Override
    public SpreadSheetColumnRange getColRange() {
        return this.m_ColRange;
    }

    @Override
    public String colRangeTipText() {
        return "The range of columns to use in the filtering process.";
    }

    @Override
    public void setColRegExp(BaseRegExp value) {
        this.m_ColRegExp = value;
        this.reset();
    }

    @Override
    public BaseRegExp getColRegExp() {
        return this.m_ColRegExp;
    }

    @Override
    public String colRegExpTipText() {
        return "The regular expression to use on the column names to determine whether to use a column for filtering.";
    }

    @Override
    public void setDropOtherColumns(boolean value) {
        this.m_DropOtherColumns = value;
        this.reset();
    }

    @Override
    public boolean getDropOtherColumns() {
        return this.m_DropOtherColumns;
    }

    @Override
    public String dropOtherColumnsTipText() {
        return "If enabled, other columns that aren't used for filtering get removed from the output; does not affect any class columns.";
    }

    protected void initColumns(Dataset data) throws Exception {
        String msg;
        int i;
        TIntArrayList cols = null;
        switch (this.m_ColumnSubset) {
            case RANGE: {
                if (this.m_ColRange.isAllRange()) break;
                this.m_ColRange.setSpreadSheet((SpreadSheet)data);
                cols = new TIntArrayList(this.m_ColRange.getIntIndices());
                break;
            }
            case REGEXP: {
                if (this.m_ColRegExp.isMatchAll()) break;
                cols = new TIntArrayList();
                for (i = 0; i < data.getColumnCount(); ++i) {
                    if (!this.m_ColRegExp.isMatch(data.getColumnName(i))) continue;
                    cols.add(i);
                }
                break;
            }
            default: {
                throw new Exception("Unhandled column determination: " + (Object)((Object)this.m_ColumnSubset));
            }
        }
        this.m_ClassColumns.add(data.getClassAttributeIndices());
        Capabilities caps = this.getCapabilities();
        if (cols != null) {
            for (int col : cols.toArray()) {
                msg = CapabilitiesHelper.handles(caps, data, col);
                if (msg != null || data.isClassAttribute(col)) continue;
                this.m_DataColumns.add(col);
            }
        } else {
            for (i = 0; i < data.getColumnCount(); ++i) {
                msg = CapabilitiesHelper.handles(caps, data, i);
                if (msg != null || data.isClassAttribute(i)) continue;
                this.m_DataColumns.add(i);
            }
        }
        if (!this.m_DropOtherColumns) {
            for (i = 0; i < data.getColumnCount(); ++i) {
                if (this.m_DataColumns.contains(i) || this.m_ClassColumns.contains(i)) continue;
                this.m_OtherColumns.add(i);
            }
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Data cols: " + this.m_DataColumns);
            this.getLogger().info("Class cols: " + this.m_ClassColumns);
            this.getLogger().info("Other cols: " + this.m_OtherColumns);
        }
    }
}

