/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option.help;

import adams.core.Utils;
import adams.core.option.help.AbstractHelpGenerator;
import adams.core.option.help.HelpFormat;
import adams.ml.capabilities.Capabilities;
import adams.ml.capabilities.CapabilitiesHandler;
import nz.ac.waikato.cms.locator.ClassLocator;

public class CapabilitiesInfo
extends AbstractHelpGenerator {
    private static final long serialVersionUID = -3885494293535045819L;

    public String globalInfo() {
        return "Generates help for classes that implement the " + Utils.classToString(CapabilitiesHandler.class) + " interface.";
    }

    public boolean handles(Class cls) {
        return ClassLocator.matches(CapabilitiesHandler.class, (Class)cls);
    }

    public String generate(Object obj, HelpFormat format) {
        StringBuilder result = new StringBuilder();
        Capabilities caps = ((CapabilitiesHandler)obj).getCapabilities();
        if (caps != null) {
            switch (format) {
                case PLAIN_TEXT: {
                    result.append("Capabilities\n");
                    result.append(caps.toString());
                    result.append("\n\n");
                    break;
                }
                case HTML: {
                    result.append("<h2>Capabilities</h2>\n");
                    result.append("<p>" + this.toHTML(caps.toString(), true) + "</p>\n");
                    result.append("<br>\n");
                    result.append("\n");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled format: " + format);
                }
            }
        }
        return result.toString();
    }
}

