/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.DateFormat;
import adams.core.DateTimeMsec;
import adams.core.Utils;
import adams.data.DateFormatString;
import adams.data.io.input.AbstractSpreadSheetReader;
import adams.data.io.output.SimpleArffSpreadSheetWriter;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetUtils;
import adams.env.Environment;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;

public class SimpleArffSpreadSheetReader
extends AbstractSpreadSheetReader {
    private static final long serialVersionUID = 7620213946139044919L;
    public static final String KEYWORD_RELATION = "@relation";
    public static final String KEYWORD_ATTRIBUTE = "@attribute";
    public static final String KEYWORD_DATA = "@data";

    public String globalInfo() {
        return "Simple reader for Weka ARFF files, only supports NUMERIC, NOMINAL, STRING and DATE attributes.";
    }

    public String getFormatDescription() {
        return "Simple ARFF file";
    }

    public String[] getFormatExtensions() {
        return new String[]{"arff", "arff.gz"};
    }

    protected AbstractSpreadSheetReader.InputType getInputType() {
        return AbstractSpreadSheetReader.InputType.READER;
    }

    public SpreadSheetWriter getCorrespondingWriter() {
        return new SimpleArffSpreadSheetWriter();
    }

    protected boolean supportsCompressedInput() {
        return true;
    }

    protected HashMap<String, String> parseAttribute(String line) {
        boolean quoted;
        HashMap<String, String> result = new HashMap<String, String>();
        String current = line.replace("\t", " ");
        if ((current = current.substring(KEYWORD_ATTRIBUTE.length() + 1).trim()).startsWith("'")) {
            quoted = true;
            result.put("name", current.substring(1, current.indexOf(39, 1)).trim());
        } else if (current.startsWith("\"")) {
            quoted = true;
            result.put("name", current.substring(1, current.indexOf(34, 1)).trim());
        } else {
            quoted = false;
            result.put("name", current.substring(0, current.indexOf(32, 1)).trim());
        }
        current = current.substring(((String)result.get("name")).length() + (quoted ? 2 : 0)).trim();
        String lower = current.toLowerCase();
        if (lower.startsWith("numeric") || lower.startsWith("real") || lower.startsWith("integer")) {
            result.put("type", AttributeType.NUMERIC.toString());
        } else if (lower.startsWith("string")) {
            result.put("type", AttributeType.STRING.toString());
        } else if (lower.startsWith("date")) {
            result.put("type", AttributeType.DATE.toString());
        } else if (lower.startsWith("{")) {
            result.put("type", AttributeType.NOMINAL.toString());
        } else {
            throw new IllegalStateException("Unsupported attribute: " + current);
        }
        if (((String)result.get("type")).equals(AttributeType.DATE.toString())) {
            String format = (current = current.substring(5).trim()).startsWith("'") ? Utils.unquote((String)current) : (current.startsWith("\"") ? Utils.unDoubleQuote((String)current) : current);
            if (new DateFormatString().isValid(format)) {
                result.put("format", format);
            } else {
                throw new IllegalStateException("Invalid date format: " + format);
            }
        }
        return result;
    }

    protected String getAttributeName(String line) {
        return this.parseAttribute(line).get("name");
    }

    protected AttributeType getAttributeType(String line) {
        return AttributeType.valueOf(this.parseAttribute(line).get("type"));
    }

    protected DateFormat getAttributeDateFormat(String line) {
        HashMap<String, String> data = this.parseAttribute(line);
        if (data.containsKey("format")) {
            return new DateFormat(data.get("format"));
        }
        return null;
    }

    protected SpreadSheet doRead(Reader r) {
        DefaultSpreadSheet result = new DefaultSpreadSheet();
        BufferedReader reader = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
        int lineIndex = 0;
        boolean header = true;
        HeaderRow row = null;
        ArrayList<AttributeType> types = new ArrayList<AttributeType>();
        ArrayList<DateFormat> formats = new ArrayList<DateFormat>();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                ++lineIndex;
                if ((line = line.trim()).isEmpty() || line.startsWith("%")) continue;
                if (header) {
                    String lower;
                    if (row == null) {
                        row = result.getHeaderRow();
                    }
                    if ((lower = line.toLowerCase()).startsWith(KEYWORD_RELATION)) {
                        result.setName(Utils.unquote((String)line.substring(KEYWORD_RELATION.length()).trim()));
                        continue;
                    }
                    if (lower.startsWith(KEYWORD_ATTRIBUTE)) {
                        row.addCell("" + row.getCellCount()).setContentAsString(Utils.unquote((String)this.getAttributeName(line)));
                        types.add(this.getAttributeType(line));
                        formats.add(this.getAttributeDateFormat(line));
                        continue;
                    }
                    if (!lower.startsWith(KEYWORD_DATA)) continue;
                    header = false;
                    continue;
                }
                String[] cells = SpreadSheetUtils.split((String)line, (char)',', (boolean)false, (char)'\'', (boolean)true);
                row = result.addRow();
                block8: for (int i = 0; i < cells.length && i < result.getColumnCount(); ++i) {
                    cells[i] = cells[i].trim();
                    if (cells[i].equals("?")) continue;
                    Cell cell = row.addCell(i);
                    if (!cells[i].equals("'?'")) {
                        cells[i] = Utils.unquote((String)cells[i]);
                    }
                    switch ((AttributeType)((Object)types.get(i))) {
                        case NUMERIC: {
                            if (Utils.isLong((String)cells[i])) {
                                cell.setContent(Long.valueOf(Long.parseLong(cells[i])));
                                continue block8;
                            }
                            cell.setContent(Double.valueOf(Double.parseDouble(cells[i])));
                            continue block8;
                        }
                        case NOMINAL: 
                        case STRING: {
                            cell.setContentAsString(cells[i]);
                            continue block8;
                        }
                        case DATE: {
                            cell.setContent(new DateTimeMsec(((DateFormat)formats.get(i)).parse(cells[i])));
                            continue block8;
                        }
                        default: {
                            throw new IllegalStateException("Unhandled attribute type: " + types.get(i));
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to read ARFF data from reader (line #" + (lineIndex + 1) + ")!", (Throwable)e);
            result = null;
        }
        return result;
    }

    public static void main(String[] args) {
        SimpleArffSpreadSheetReader.runReader(Environment.class, SimpleArffSpreadSheetReader.class, (String[])args);
    }

    public static enum AttributeType {
        NUMERIC,
        NOMINAL,
        STRING,
        DATE;

    }
}

