/*
 * Decompiled with CFR 0.152.
 */
package adams.data.splitgenerator.generic.splitter;

import adams.core.option.AbstractOptionHandler;
import adams.data.binning.Binnable;
import adams.data.splitgenerator.generic.splitter.Splitter;
import com.github.fracpete.javautils.struct.Struct2;
import java.util.List;

public abstract class AbstractSplitter
extends AbstractOptionHandler
implements Splitter {
    private static final long serialVersionUID = -5619683133352175979L;

    @Override
    public void reset() {
        super.reset();
    }

    protected <T> String check(List<Binnable<T>> data) {
        if (data == null || data.size() == 0) {
            return "No data provided!";
        }
        if (data.size() < this.getMinimumSize()) {
            return "Not enough data for splitting: " + data.size() + " < " + this.getMinimumSize();
        }
        return null;
    }

    protected int getMinimumSize() {
        return 2;
    }

    protected abstract <T> Struct2<List<Binnable<T>>, List<Binnable<T>>> doSplit(List<Binnable<T>> var1);

    @Override
    public <T> Struct2<List<Binnable<T>>, List<Binnable<T>>> split(List<Binnable<T>> data) {
        String msg = this.check(data);
        if (msg != null) {
            throw new IllegalStateException(msg);
        }
        return this.doSplit(data);
    }
}

