/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control.removeoutliers;

import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.flow.control.removeoutliers.AbstractOutlierDetector;

public abstract class AbstractNumericOutlierDetector
extends AbstractOutlierDetector {
    private static final long serialVersionUID = 8204585970761312700L;

    @Override
    public String check(SpreadSheet sheet, SpreadSheetColumnIndex actual, SpreadSheetColumnIndex predicted) {
        Object result = super.check(sheet, actual, predicted);
        if (result == null) {
            if (!sheet.isNumeric(actual.getIntIndex())) {
                result = "'Actual' column is not numeric: " + actual;
            } else if (!sheet.isNumeric(predicted.getIntIndex())) {
                result = "'Predicted' column is not numeric: " + predicted;
            }
        }
        return result;
    }

    protected Double[] extractColumn(SpreadSheet sheet, SpreadSheetColumnIndex col) {
        Double[] result = new Double[sheet.getRowCount()];
        int index = col.getIntIndex();
        for (int i = 0; i < sheet.getRowCount(); ++i) {
            DataRow row = sheet.getRow(i);
            Double value = null;
            if (row.hasCell(index) && !row.getCell(index).isMissing()) {
                value = row.getCell(index).toDouble();
            }
            result[i] = value;
        }
        return result;
    }

    protected double[] diff(Double[] actual, Double[] predicted, boolean useRelative) {
        double[] result = new double[actual.length];
        for (int i = 0; i < actual.length; ++i) {
            if (actual[i] != null && predicted[i] != null) {
                result[i] = actual[i] - predicted[i];
                if (!useRelative) continue;
                if (actual[i] != 0.0) {
                    int n = i;
                    result[n] = result[n] / actual[i];
                    continue;
                }
                result[i] = Double.NaN;
                continue;
            }
            result[i] = Double.NaN;
        }
        return result;
    }

    protected double[] diff(SpreadSheet sheet, SpreadSheetColumnIndex actual, SpreadSheetColumnIndex predicted, boolean useRelative) {
        return this.diff(this.extractColumn(sheet, actual), this.extractColumn(sheet, predicted), useRelative);
    }
}

