/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.ClassCrossReference;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.FileBasedDatasetContainer;
import adams.flow.control.SetContainerValue;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.PrepareFileBasedDataset;
import adams.flow.transformer.generatefilebaseddataset.AbstractFileBasedDatasetGeneration;
import adams.flow.transformer.generatefilebaseddataset.SimpleFileList;

public class GenerateFileBasedDataset
extends AbstractTransformer
implements ClassCrossReference {
    private static final long serialVersionUID = -5135595330787325026L;
    protected AbstractFileBasedDatasetGeneration m_Generation;

    public String globalInfo() {
        return "Applies the specified generator to the incoming dataset container.";
    }

    public Class[] getClassCrossReferences() {
        return new Class[]{SetContainerValue.class, PrepareFileBasedDataset.class};
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generation", "generation", (Object)new SimpleFileList());
    }

    public void setGeneration(AbstractFileBasedDatasetGeneration value) {
        this.m_Generation = value;
        this.reset();
    }

    public AbstractFileBasedDatasetGeneration getGeneration() {
        return this.m_Generation;
    }

    public String generationTipText() {
        return "The dataset generation scheme to apply to the container.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"generation", (Object)((Object)this.m_Generation));
    }

    public Class[] accepts() {
        return new Class[]{FileBasedDatasetContainer.class};
    }

    public Class[] generates() {
        return new Class[]{this.m_Generation.generates()};
    }

    protected String doExecute() {
        String result = null;
        try {
            Object output = this.m_Generation.generate((FileBasedDatasetContainer)((Object)this.m_InputToken.getPayload(FileBasedDatasetContainer.class)));
            this.m_OutputToken = new Token(output);
        }
        catch (Exception e) {
            result = this.handleException("Failed to generate dataset!", e);
        }
        return result;
    }
}

