/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.data.spreadsheet.SpreadSheetUtils;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractSpreadSheetTransformer;
import adams.flow.transformer.summarystatistics.CategoricalSummaryStatistic;
import adams.flow.transformer.summarystatistics.NumericSummaryStatistic;
import adams.flow.transformer.summarystatistics.SummaryStatistic;

public class SummaryStatistics
extends AbstractSpreadSheetTransformer {
    private static final long serialVersionUID = 453666335915022509L;
    protected SpreadSheetColumnIndex m_ActualColumn;
    protected String m_ActualPrefix;
    protected SpreadSheetColumnIndex m_PredictedColumn;
    protected String m_PredictedPrefix;
    protected SpreadSheetColumnIndex m_ProbabilityColumn;
    protected SpreadSheetColumnRange m_ClassDistributionRange;
    protected SummaryStatistic[] m_Statistics;

    public String globalInfo() {
        return "Calculates the selected summary statistics and outputs a spreadsheet.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("actual-column", "actualColumn", (Object)new SpreadSheetColumnIndex("1"));
        this.m_OptionManager.add("actual-prefix", "actualPrefix", (Object)"a: ");
        this.m_OptionManager.add("predicted-column", "predictedColumn", (Object)new SpreadSheetColumnIndex("2"));
        this.m_OptionManager.add("predicted-prefix", "predictedPrefix", (Object)"p: ");
        this.m_OptionManager.add("probability-column", "probabilityColumn", (Object)new SpreadSheetColumnIndex(""));
        this.m_OptionManager.add("class-distribution-range", "classDistributionRange", (Object)new SpreadSheetColumnRange(""));
        this.m_OptionManager.add("statistic", "statistics", (Object)new SummaryStatistic[0]);
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"actualColumn", (Object)this.m_ActualColumn, (String)"actual: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"predictedColumn", (Object)this.m_PredictedColumn, (String)", predicted: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"probabilityColumn", (Object)(this.m_ProbabilityColumn.isEmpty() ? "-none-" : this.m_ProbabilityColumn.getIndex()), (String)", probability: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"classDistributionRange", (Object)(this.m_ClassDistributionRange.isEmpty() ? "-none-" : this.m_ClassDistributionRange.getRange()), (String)", class dist: ");
        return result;
    }

    public void setActualColumn(SpreadSheetColumnIndex value) {
        this.m_ActualColumn = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getActualColumn() {
        return this.m_ActualColumn;
    }

    public String actualColumnTipText() {
        return "The column with the actual labels.";
    }

    public void setActualPrefix(String value) {
        this.m_ActualPrefix = value;
        this.reset();
    }

    public String getActualPrefix() {
        return this.m_ActualPrefix;
    }

    public String actualPrefixTipText() {
        return "The prefix for the actual labels.";
    }

    public void setPredictedColumn(SpreadSheetColumnIndex value) {
        this.m_PredictedColumn = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getPredictedColumn() {
        return this.m_PredictedColumn;
    }

    public String predictedColumnTipText() {
        return "The column with the predicted labels.";
    }

    public void setPredictedPrefix(String value) {
        this.m_PredictedPrefix = value;
        this.reset();
    }

    public String getPredictedPrefix() {
        return this.m_PredictedPrefix;
    }

    public String predictedPrefixTipText() {
        return "The prefix for the predicted labels.";
    }

    public void setProbabilityColumn(SpreadSheetColumnIndex value) {
        this.m_ProbabilityColumn = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getProbabilityColumn() {
        return this.m_ProbabilityColumn;
    }

    public String probabilityColumnTipText() {
        return "The (optional) column with the probabilities; if not available probability of 1 is assumed.";
    }

    public void setClassDistributionRange(SpreadSheetColumnRange value) {
        this.m_ClassDistributionRange = value;
        this.reset();
    }

    public SpreadSheetColumnRange getClassDistributionRange() {
        return this.m_ClassDistributionRange;
    }

    public String classDistributionRangeTipText() {
        return "The (optional) columns with the class distributions; if not available probability of 1 is assumed for predicted label.";
    }

    public void setStatistics(SummaryStatistic[] value) {
        this.m_Statistics = value;
        this.reset();
    }

    public SummaryStatistic[] getStatistics() {
        return this.m_Statistics;
    }

    public String statisticsTipText() {
        return "The statistics to compute.";
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload(SpreadSheet.class);
        this.m_ActualColumn.setData((Object)sheet);
        this.m_PredictedColumn.setData((Object)sheet);
        this.m_ProbabilityColumn.setData((Object)sheet);
        this.m_ClassDistributionRange.setData((Object)sheet);
        int actCol = this.m_ActualColumn.getIntIndex();
        int predCol = this.m_PredictedColumn.getIntIndex();
        int probCol = this.m_ProbabilityColumn.getIntIndex();
        int[] distCols = this.m_ClassDistributionRange.getIntIndices();
        if (actCol == -1) {
            result = "Actual column not found: " + this.m_ActualColumn;
        } else if (predCol == -1) {
            result = "Predicted column not found: " + this.m_PredictedColumn;
        }
        if (result == null) {
            int i;
            String[] labels;
            double[][] dist;
            DefaultSpreadSheet stats = new DefaultSpreadSheet();
            HeaderRow row = stats.getHeaderRow();
            row.addCell("K").setContentAsString("Statistic");
            row.addCell("V").setContentAsString("Value");
            boolean numeric = sheet.isNumeric(actCol) && sheet.isNumeric(predCol);
            double[] prob = probCol != -1 ? SpreadSheetUtils.getNumericColumn((SpreadSheet)sheet, (int)probCol) : null;
            if (distCols.length == 0) {
                dist = null;
                labels = null;
            } else {
                dist = new double[distCols.length][];
                labels = new String[distCols.length];
                for (i = 0; i < distCols.length; ++i) {
                    dist[i] = SpreadSheetUtils.getNumericColumn((SpreadSheet)sheet, (int)distCols[i]);
                    labels[i] = sheet.getColumnName(distCols[i]);
                }
            }
            if (numeric) {
                double[] actNum = SpreadSheetUtils.getNumericColumn((SpreadSheet)sheet, (int)actCol);
                double[] predNum = SpreadSheetUtils.getNumericColumn((SpreadSheet)sheet, (int)predCol);
                for (SummaryStatistic s : this.m_Statistics) {
                    if (s instanceof NumericSummaryStatistic) {
                        NumericSummaryStatistic numStat = (NumericSummaryStatistic)s;
                        numStat.setNumericActual(actNum);
                        numStat.setNumericPredicted(predNum);
                        String[] names = numStat.getNames();
                        double[] values = numStat.calculate();
                        for (i = 0; i < names.length; ++i) {
                            row = stats.addRow();
                            row.addCell("K").setContentAsString(names[i]);
                            row.addCell("V").setContent(Double.valueOf(values[i]));
                        }
                        continue;
                    }
                    this.getLogger().warning("Statistic " + Utils.classToString((Object)s) + " is not for numeric predictions, skipping!");
                }
            } else {
                String[] actCat = SpreadSheetUtils.getColumn((SpreadSheet)sheet, (int)actCol, (boolean)false, (boolean)false, (String)"???");
                String[] predCat = SpreadSheetUtils.getColumn((SpreadSheet)sheet, (int)predCol, (boolean)false, (boolean)false, (String)"???");
                for (SummaryStatistic s : this.m_Statistics) {
                    if (s instanceof CategoricalSummaryStatistic) {
                        CategoricalSummaryStatistic catStat = (CategoricalSummaryStatistic)s;
                        catStat.setCategoricalActual(actCat);
                        catStat.setCategoricalPredicted(predCat);
                        catStat.setCategoricalProbabilities(prob);
                        catStat.setCategoricalClassDistributions(dist);
                        catStat.setCategoricalClassDistributionLabels(labels);
                        String[] names = catStat.getNames();
                        double[] values = catStat.calculate();
                        for (i = 0; i < names.length; ++i) {
                            row = stats.addRow();
                            row.addCell("K").setContentAsString(names[i]);
                            row.addCell("V").setContent(Double.valueOf(values[i]));
                        }
                        continue;
                    }
                    this.getLogger().warning("Statistic " + Utils.classToString((Object)s) + " is not for categorical predictions, skipping!");
                }
            }
            this.m_OutputToken = new Token((Object)stats);
        }
        return result;
    }
}

