/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.preparefilebaseddataset;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.binning.operation.Wrapping;
import adams.data.splitgenerator.generic.crossvalidation.CrossValidationGenerator;
import adams.data.splitgenerator.generic.crossvalidation.FoldPair;
import adams.data.splitgenerator.generic.randomization.DefaultRandomization;
import adams.data.splitgenerator.generic.randomization.PassThrough;
import adams.flow.container.FileBasedDatasetContainer;
import adams.flow.transformer.preparefilebaseddataset.AbstractRandomizableFileBasedDatasetPreparation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CrossValidation
extends AbstractRandomizableFileBasedDatasetPreparation<String[]> {
    private static final long serialVersionUID = 7027794624748574933L;
    protected int m_NumFolds;
    protected int m_ActualNumFolds;
    protected boolean m_Randomize;

    public String globalInfo() {
        return "Generates cross-validation folds.\nIf number of folds is less than 2, leave-one-out is performed.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-folds", "numFolds", (Object)10);
        this.m_OptionManager.add("randomize", "randomize", (Object)true);
    }

    protected void reset() {
        super.reset();
        this.m_ActualNumFolds = -1;
    }

    public void setNumFolds(int value) {
        this.m_NumFolds = value;
        this.reset();
    }

    public int getNumFolds() {
        return this.m_NumFolds;
    }

    public String numFoldsTipText() {
        return "The number of folds; use <2 for leave one out (LOO).";
    }

    public int getActualNumFolds() {
        return this.m_ActualNumFolds;
    }

    public void setRandomize(boolean value) {
        this.m_Randomize = value;
        this.reset();
    }

    public boolean getRandomize() {
        return this.m_Randomize;
    }

    public String randomizeTipText() {
        return "If enabled, the data is randomized first.";
    }

    @Override
    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"numFolds", (Object)this.m_NumFolds, (String)"folds: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"randomize", (boolean)this.m_Randomize, (String)"randomize", (String)", ");
        return result;
    }

    @Override
    public Class accepts() {
        return String[].class;
    }

    @Override
    protected String check(String[] data) {
        Object result = super.check(data);
        if (result == null) {
            if (this.m_NumFolds < 2) {
                if (data.length < 2) {
                    result = "At least two files required, provided: " + data.length;
                }
            } else if (data.length < this.m_NumFolds) {
                result = "At least " + this.m_NumFolds + " files required, provided: " + data.length;
            }
        }
        return result;
    }

    @Override
    protected List<FileBasedDatasetContainer> doPrepare(String[] data) {
        List binnable;
        ArrayList<FileBasedDatasetContainer> result = new ArrayList<FileBasedDatasetContainer>();
        CrossValidationGenerator generator = new CrossValidationGenerator();
        generator.setNumFolds(this.m_NumFolds);
        generator.setStratification(new adams.data.splitgenerator.generic.stratification.PassThrough());
        if (this.m_Randomize) {
            DefaultRandomization defRand = new DefaultRandomization();
            defRand.setSeed(this.m_Seed);
            defRand.setLoggingLevel(this.m_LoggingLevel);
            generator.setRandomization(defRand);
        } else {
            generator.setRandomization(new PassThrough());
        }
        try {
            binnable = Wrapping.wrap(Arrays.asList(data), (Wrapping.BinValueExtractor)new Wrapping.IndexedBinValueExtractor());
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to wrap file names in Binnable objects!");
        }
        List foldPairs = generator.generate(binnable);
        for (FoldPair foldPair : foldPairs) {
            String[] train = Wrapping.unwrap(foldPair.getTrain().getData()).toArray(new String[0]);
            String[] test = Wrapping.unwrap(foldPair.getTest().getData()).toArray(new String[0]);
            result.add(new FileBasedDatasetContainer(train, test));
        }
        this.m_ActualNumFolds = result.size();
        return result;
    }
}

