/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.preparefilebaseddataset;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.data.binning.BinnableFiles;
import adams.data.binning.operation.Grouping;
import adams.data.binning.operation.Wrapping;
import adams.data.splitgenerator.generic.core.Subset;
import adams.data.splitgenerator.generic.randomization.DefaultRandomization;
import adams.data.splitgenerator.generic.randomization.PassThrough;
import adams.data.splitgenerator.generic.randomsplit.RandomSplitGenerator;
import adams.data.splitgenerator.generic.randomsplit.SplitPair;
import adams.data.splitgenerator.generic.splitter.DefaultSplitter;
import adams.flow.transformer.preparefilebaseddataset.TrainValidateTestSplit;
import com.github.fracpete.javautils.struct.Struct2;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class GroupedTrainValidateTestSplit
extends TrainValidateTestSplit {
    private static final long serialVersionUID = 7027794624748574933L;
    protected BaseRegExp m_RegExp;
    protected String m_Group;
    protected boolean m_UseOnlyName;
    protected boolean m_RemoveExtension;

    @Override
    public String globalInfo() {
        return "Generates a train/test split.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("regexp", "regExp", (Object)new BaseRegExp(".*"));
        this.m_OptionManager.add("group", "group", (Object)"$0");
        this.m_OptionManager.add("use-only-name", "useOnlyName", (Object)true);
        this.m_OptionManager.add("remove-extension", "removeExtension", (Object)false);
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression for identifying the group (eg '^(.*)-([0-9]+)-(.*)$').";
    }

    public void setGroup(String value) {
        this.m_Group = value;
        this.reset();
    }

    public String getGroup() {
        return this.m_Group;
    }

    public String groupTipText() {
        return "The replacement string to use as group (eg '$2').";
    }

    public void setUseOnlyName(boolean value) {
        this.m_UseOnlyName = value;
        this.reset();
    }

    public boolean getUseOnlyName() {
        return this.m_UseOnlyName;
    }

    public String useOnlyNameTipText() {
        return "If enabled, only the file name, not the path, will be used in the grouping.";
    }

    public void setRemoveExtension(boolean value) {
        this.m_RemoveExtension = value;
        this.reset();
    }

    public boolean getRemoveExtension() {
        return this.m_RemoveExtension;
    }

    public String removeExtensionTipText() {
        return "If enabled, the extension gets removed before applying the regular expression.";
    }

    @Override
    public String getQuickInfo() {
        Object result = super.getQuickInfo();
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"regExp", (BaseRegExp)this.m_RegExp, (String)", regexp: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"group", (Object)this.m_Group, (String)", group: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"useOnlyName", (boolean)this.m_UseOnlyName, (String)"only name", (String)", ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"removeExtension", (boolean)this.m_RemoveExtension, (String)"no ext", (String)", ");
        return result;
    }

    @Override
    public Class accepts() {
        return String[].class;
    }

    @Override
    protected String check(String[] data) {
        Object result = super.check(data);
        if (result == null && data.length < 2) {
            result = "At least two files required, provided: " + data.length;
        }
        return result;
    }

    @Override
    protected Struct2<String[], String[]> split(String[] data, double percentage) {
        List binnableGroups;
        RandomSplitGenerator generator = new RandomSplitGenerator();
        DefaultSplitter splitter = new DefaultSplitter();
        splitter.setPercentage(percentage);
        generator.setSplitter(splitter);
        if (!this.m_PreserveOrder) {
            DefaultRandomization defRand = new DefaultRandomization();
            defRand.setSeed(this.m_Seed);
            defRand.setLoggingLevel(this.m_LoggingLevel);
            generator.setRandomization(defRand);
        } else {
            generator.setRandomization(new PassThrough());
        }
        try {
            List binnableFiles = Wrapping.wrap(Arrays.asList(data), (Wrapping.BinValueExtractor)new Wrapping.IndexedBinValueExtractor());
            binnableFiles = Wrapping.addTmpIndex((List)binnableFiles);
            List groupedFiles = Grouping.groupAsList((List)binnableFiles, (Grouping.GroupExtractor)new BinnableFiles.FileGroupExtractor(this.m_UseOnlyName, this.m_RemoveExtension, this.m_RegExp.getValue(), this.m_Group));
            binnableGroups = Wrapping.wrap((Collection)groupedFiles, (Wrapping.BinValueExtractor)new Wrapping.IndexedBinValueExtractor());
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to wrap file names in Binnable objects!");
        }
        SplitPair splitGroups = generator.generate(binnableGroups);
        Struct2 subsetTrain = Subset.extractIndicesAndBinnable(splitGroups.getTrain());
        Struct2 subsetTest = Subset.extractIndicesAndBinnable(splitGroups.getTest());
        String[] train = BinnableFiles.toStringArray((List)subsetTrain.value2);
        String[] test = BinnableFiles.toStringArray((List)subsetTest.value2);
        return new Struct2((Object)train, (Object)test);
    }
}

