/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.preparefilebaseddataset;

import adams.core.Index;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.FileBasedDatasetContainer;
import adams.flow.transformer.preparefilebaseddataset.AbstractFileBasedDatasetPreparation;
import java.util.ArrayList;
import java.util.List;

public class Selected
extends AbstractFileBasedDatasetPreparation<String[][]> {
    private static final long serialVersionUID = 7027794624748574933L;
    protected Index m_Train;
    protected Index m_Test;
    protected Index m_Validation;
    protected Index m_Negative;

    public String globalInfo() {
        return "Generates a container from the selected array indices.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("train", "train", (Object)new Index(""));
        this.m_OptionManager.add("test", "test", (Object)new Index(""));
        this.m_OptionManager.add("validation", "validation", (Object)new Index(""));
        this.m_OptionManager.add("negative", "negative", (Object)new Index(""));
    }

    public void setTrain(Index value) {
        this.m_Train = value;
        this.reset();
    }

    public Index getTrain() {
        return this.m_Train;
    }

    public String trainTipText() {
        return "The index in the array for the training set.";
    }

    public void setTest(Index value) {
        this.m_Test = value;
        this.reset();
    }

    public Index getTest() {
        return this.m_Test;
    }

    public String testTipText() {
        return "The index in the array for the test set.";
    }

    public void setValidation(Index value) {
        this.m_Validation = value;
        this.reset();
    }

    public Index getValidation() {
        return this.m_Validation;
    }

    public String validationTipText() {
        return "The index in the array for the validation set.";
    }

    public void setNegative(Index value) {
        this.m_Negative = value;
        this.reset();
    }

    public Index getNegative() {
        return this.m_Negative;
    }

    public String negativeTipText() {
        return "The index in the array for the negative set.";
    }

    @Override
    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"train", (Object)(this.m_Train.isEmpty() ? "-empty-" : this.m_Train.getIndex()), (String)"train: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"test", (Object)(this.m_Test.isEmpty() ? "-empty-" : this.m_Test.getIndex()), (String)", test: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"validation", (Object)(this.m_Validation.isEmpty() ? "-empty-" : this.m_Validation.getIndex()), (String)", validation: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"negative", (Object)(this.m_Negative.isEmpty() ? "-empty-" : this.m_Negative.getIndex()), (String)", negative: ");
        return result;
    }

    @Override
    public Class accepts() {
        return String[][].class;
    }

    @Override
    protected String check(String[][] data) {
        Object result = super.check(data);
        int count = 0;
        if (result == null && !this.m_Train.isEmpty()) {
            this.m_Train.setMax(data.length);
            if (this.m_Train.getIntIndex() == -1) {
                result = "Train index not available from input data: " + this.m_Train.getIndex();
            } else {
                ++count;
            }
        }
        if (result == null && !this.m_Test.isEmpty()) {
            this.m_Test.setMax(data.length);
            if (this.m_Test.getIntIndex() == -1) {
                result = "Test index not available from input data: " + this.m_Test.getIndex();
            } else {
                ++count;
            }
        }
        if (result == null && !this.m_Validation.isEmpty()) {
            this.m_Validation.setMax(data.length);
            if (this.m_Validation.getIntIndex() == -1) {
                result = "Validation index not available from input data: " + this.m_Validation.getIndex();
            } else {
                ++count;
            }
        }
        if (result == null && !this.m_Negative.isEmpty()) {
            this.m_Negative.setMax(data.length);
            if (this.m_Negative.getIntIndex() == -1) {
                result = "Negative index not available from input data: " + this.m_Negative.getIndex();
            } else {
                ++count;
            }
        }
        if (result == null && count == 0) {
            result = "No index selected for dataset!";
        }
        return result;
    }

    @Override
    protected List<FileBasedDatasetContainer> doPrepare(String[][] data) {
        String[] train = null;
        if (this.m_Train.getIntIndex() > -1) {
            train = data[this.m_Train.getIntIndex()];
        }
        String[] test = null;
        if (this.m_Test.getIntIndex() > -1) {
            test = data[this.m_Test.getIntIndex()];
        }
        String[] validation = null;
        if (this.m_Validation.getIntIndex() > -1) {
            validation = data[this.m_Validation.getIntIndex()];
        }
        String[] negative = null;
        if (this.m_Negative.getIntIndex() > -1) {
            negative = data[this.m_Negative.getIntIndex()];
        }
        FileBasedDatasetContainer cont = new FileBasedDatasetContainer(train != null ? (String[])train.clone() : null, test != null ? (String[])test.clone() : null, validation != null ? (String[])validation.clone() : null, negative != null ? (String[])negative.clone() : null);
        ArrayList<FileBasedDatasetContainer> result = new ArrayList<FileBasedDatasetContainer>();
        result.add(cont);
        return result;
    }
}

