/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.summarystatistics;

import adams.flow.transformer.summarystatistics.AbstractSummaryStatistic;
import adams.flow.transformer.summarystatistics.CategoricalSummaryStatistic;
import adams.flow.transformer.summarystatistics.NumericSummaryStatistic;

public abstract class AbstractGeneralSummaryStatistic
extends AbstractSummaryStatistic
implements NumericSummaryStatistic,
CategoricalSummaryStatistic {
    private static final long serialVersionUID = -3507256835214071742L;
    protected double[] m_NumericActual;
    protected double[] m_NumericPredicted;
    protected String[] m_CategoricalActual;
    protected String[] m_CategoricalPredicted;
    protected double[] m_CategoricalProbabilities;
    protected double[][] m_CategoricalClassDistributions;
    protected String[] m_CategoricalClassDistributionLabels;

    @Override
    public void clear() {
        super.clear();
        this.m_NumericActual = null;
        this.m_NumericPredicted = null;
        this.m_CategoricalActual = null;
        this.m_CategoricalPredicted = null;
        this.m_CategoricalProbabilities = null;
        this.m_CategoricalClassDistributions = null;
        this.m_CategoricalClassDistributionLabels = null;
    }

    @Override
    public void setNumericActual(double[] value) {
        this.m_NumericActual = value;
    }

    @Override
    public double[] getNumericActual() {
        return this.m_NumericActual;
    }

    @Override
    public void setNumericPredicted(double[] value) {
        this.m_NumericPredicted = value;
    }

    @Override
    public double[] getNumericPredicted() {
        return this.m_NumericPredicted;
    }

    @Override
    public void setCategoricalActual(String[] value) {
        this.m_CategoricalActual = value;
    }

    @Override
    public String[] getCategoricalActual() {
        return this.m_CategoricalActual;
    }

    @Override
    public void setCategoricalPredicted(String[] value) {
        this.m_CategoricalPredicted = value;
    }

    @Override
    public String[] getCategoricalPredicted() {
        return this.m_CategoricalPredicted;
    }

    @Override
    public void setCategoricalProbabilities(double[] value) {
        this.m_CategoricalProbabilities = value;
    }

    @Override
    public double[] getCategoricalProbabilities() {
        return this.m_CategoricalProbabilities;
    }

    @Override
    public void setCategoricalClassDistributions(double[][] value) {
        this.m_CategoricalClassDistributions = value;
    }

    @Override
    public double[][] getCategoricalClassDistributions() {
        return this.m_CategoricalClassDistributions;
    }

    @Override
    public void setCategoricalClassDistributionLabels(String[] value) {
        this.m_CategoricalClassDistributionLabels = value;
    }

    @Override
    public String[] getCategoricalClassDistributionLabels() {
        return this.m_CategoricalClassDistributionLabels;
    }

    @Override
    protected String check() {
        Object result = super.check();
        if (result == null && (this.m_NumericActual != null || this.m_NumericPredicted != null)) {
            if (this.m_NumericActual == null) {
                result = "No actual values provided!";
            } else if (this.m_NumericPredicted == null) {
                result = "No predicted values provided!";
            } else if (this.m_NumericActual.length != this.m_NumericPredicted.length) {
                result = "Differing number of actual and predicted values: " + this.m_NumericActual.length + " != " + this.m_NumericPredicted.length;
            }
        }
        if (result == null && (this.m_CategoricalActual != null || this.m_CategoricalPredicted != null)) {
            if (this.m_CategoricalActual == null) {
                result = "No actual values provided!";
            } else if (this.m_CategoricalPredicted == null) {
                result = "No predicted values provided!";
            } else if (this.m_CategoricalActual.length != this.m_CategoricalPredicted.length) {
                result = "Differing number of actual and predicted values: " + this.m_CategoricalActual.length + " != " + this.m_CategoricalPredicted.length;
            }
            if (result == null && this.m_CategoricalProbabilities != null && this.m_CategoricalPredicted.length != this.m_CategoricalProbabilities.length) {
                result = "Differing number of predicted values and probabilities: " + this.m_CategoricalPredicted.length + " != " + this.m_CategoricalProbabilities.length;
            }
            if (result == null && this.m_CategoricalClassDistributions != null) {
                if (this.m_CategoricalPredicted.length != this.m_CategoricalClassDistributions.length) {
                    result = "Differing number of predicted values and class distributions: " + this.m_CategoricalPredicted.length + " != " + this.m_CategoricalClassDistributions.length;
                } else if (this.m_CategoricalClassDistributionLabels == null) {
                    result = "No class distribution labels provided!";
                } else if (this.m_CategoricalClassDistributionLabels.length != this.m_CategoricalClassDistributions[0].length) {
                    result = "Differing number of predicted values and class distributions: " + this.m_CategoricalPredicted.length + " != " + this.m_CategoricalClassDistributions.length;
                }
            }
        }
        return result;
    }

    public boolean isNumeric() {
        return this.m_NumericActual != null && this.m_NumericPredicted != null;
    }
}

