/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.summarystatistics;

import adams.data.statistics.StatUtils;
import adams.flow.transformer.summarystatistics.AbstractNumericSummaryStatistic;
import adams.flow.transformer.summarystatistics.PredictionHelper;

public class CorrelationCoefficient
extends AbstractNumericSummaryStatistic {
    private static final long serialVersionUID = -8141027950994364855L;

    public String globalInfo() {
        return "Calculates the correlation coefficient.";
    }

    @Override
    public String[] getNames() {
        return new String[]{"Correlation coefficient"};
    }

    @Override
    protected double[] doCalculate() {
        int i;
        double[][] filtered = PredictionHelper.filterMissing(this.m_NumericActual, this.m_NumericPredicted);
        double[] act = filtered[0];
        double[] pred = filtered[1];
        double meanAct = StatUtils.mean((double[])act);
        double meanPred = StatUtils.mean((double[])pred);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("meanA: " + meanAct);
            this.getLogger().info("meanP: " + meanPred);
        }
        double sumAct = 0.0;
        for (i = 0; i < act.length; ++i) {
            sumAct += (act[i] - meanAct) * (act[i] - meanAct);
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("sumA: " + sumAct);
        }
        double sumPred = 0.0;
        for (i = 0; i < pred.length; ++i) {
            sumPred += (pred[i] - meanPred) * (pred[i] - meanPred);
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("sumP: " + sumPred);
        }
        double sumPredAct = 0.0;
        for (i = 0; i < act.length; ++i) {
            sumPredAct += (pred[i] - meanPred) * (act[i] - meanAct);
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("sumPA: " + sumPredAct);
        }
        double result = sumPredAct / (Math.sqrt(sumPred) * Math.sqrt(sumAct));
        if (this.isLoggingEnabled()) {
            this.getLogger().info("CC: " + result);
        }
        return new double[]{result};
    }
}

