/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Utils;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.spreadsheettable.CellRenderingCustomizer;
import adams.gui.core.spreadsheettable.ConfusionMatrixCellRenderingCustomizer;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.CsvSpreadSheetHandler;
import adams.gui.tools.previewbrowser.PreviewPanel;
import adams.gui.visualization.core.BiColorGenerator;
import adams.gui.visualization.core.ColorGradientGenerator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.JComponent;

public class ConfusionMatrixHandler
extends AbstractContentHandler {
    private static final long serialVersionUID = -5721119391424306170L;

    public String globalInfo() {
        return "Displays a confusion matrix from the following spreadsheet types:\n" + Utils.flatten((Object[])this.getExtensions(), (String)", ");
    }

    public String[] getExtensions() {
        return new CsvSpreadSheetHandler().getExtensions();
    }

    public PreviewPanel createPreview(File file) {
        CsvSpreadSheetReader reader = new CsvSpreadSheetReader();
        SpreadSheet sheet = reader.read(file);
        BasePanel result = new BasePanel((LayoutManager)new BorderLayout());
        SpreadSheetTable table = new SpreadSheetTable(sheet);
        table.setNumDecimals(3);
        ConfusionMatrixCellRenderingCustomizer renderer = new ConfusionMatrixCellRenderingCustomizer();
        renderer.setValueBasedBackground(true);
        BiColorGenerator generator = new BiColorGenerator();
        generator.setAlpha(128);
        generator.setFirstColor(Color.WHITE);
        generator.setSecondColor(Color.RED);
        renderer.setBackgroundColorGenerator((ColorGradientGenerator)generator);
        table.setCellRenderingCustomizer((CellRenderingCustomizer)renderer);
        result.add((Component)new BaseScrollPane((Component)table), (Object)"Center");
        return new PreviewPanel((JComponent)result, (JComponent)table);
    }
}

