/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.model;

import adams.ml.data.Dataset;
import adams.ml.data.DatasetInfo;
import adams.ml.model.Model;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ModelHelper {
    public static String isCompatible(Model model, Dataset data) {
        DatasetInfo info = model.getDatasetInfo();
        Object result = info.getHeader().equalsHeader(data);
        if (result == null) {
            Set<String> modelClasses = info.getClassColumns();
            HashSet<String> dataClasses = new HashSet<String>(Arrays.asList(data.getClassAttributeNames()));
            if (modelClasses.size() != dataClasses.size()) {
                result = "Number of class columns differ: " + modelClasses + " != " + dataClasses;
            } else if (!modelClasses.containsAll(dataClasses) || !dataClasses.containsAll(modelClasses)) {
                result = "Class column names differ: " + modelClasses + " != " + dataClasses;
            }
        }
        return result;
    }
}

