/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.preprocessing;

import adams.core.option.AbstractOptionHandler;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.ml.data.Dataset;
import adams.ml.preprocessing.Filter;
import gnu.trove.list.TIntList;

public abstract class AbstractFilter
extends AbstractOptionHandler
implements Filter {
    private static final long serialVersionUID = -7832232995060446187L;
    protected boolean m_Initialized;
    protected Dataset m_OutputFormat;

    protected void reset() {
        super.reset();
        this.m_Initialized = false;
        this.m_OutputFormat = null;
    }

    @Override
    public boolean isInitialized() {
        return this.m_Initialized;
    }

    @Override
    public Dataset getOutputFormat() {
        return this.m_OutputFormat;
    }

    protected void appendHeader(SpreadSheet input, Row header, TIntList cols) {
        for (int i = 0; i < cols.size(); ++i) {
            String colName = input.getColumnName(cols.get(i));
            header.addCell(colName + i).setContentAsString(colName);
        }
    }

    protected void appendData(Row input, Row data, TIntList cols) {
        for (int i = 0; i < cols.size(); ++i) {
            String colName = input.getOwner().getColumnName(cols.get(i));
            data.addCell(colName + i).setNative(input.getCell(cols.get(i)).getNative());
        }
    }
}

