/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.preprocessing;

import adams.data.spreadsheet.Row;
import adams.ml.data.Dataset;
import adams.ml.preprocessing.AbstractFilter;
import adams.ml.preprocessing.StreamFilter;

public abstract class AbstractStreamFilter
extends AbstractFilter
implements StreamFilter {
    private static final long serialVersionUID = -3113520581439940331L;

    protected void preInitFilter(Row data) throws Exception {
        this.reset();
    }

    protected abstract void doInitFilter(Row var1) throws Exception;

    protected abstract Dataset initOutputFormat(Row var1) throws Exception;

    protected void postInitFilter(Row data) throws Exception {
        this.m_OutputFormat = this.initOutputFormat(data);
        this.m_Initialized = true;
    }

    protected synchronized void initFilter(Row data) throws Exception {
        this.preInitFilter(data);
        this.doInitFilter(data);
        this.postInitFilter(data);
    }

    protected abstract Row doFilter(Row var1) throws Exception;

    @Override
    public synchronized Row filter(Row data) throws Exception {
        if (!this.isInitialized()) {
            this.initFilter(data);
        }
        return this.doFilter(data);
    }

    @Override
    public synchronized Dataset filter(Dataset data) throws Exception {
        Dataset result = null;
        for (Row row : data.rows()) {
            Row filtered = this.filter(row);
            if (result == null) {
                result = (Dataset)filtered.getOwner().getHeader();
            }
            result.addRow().assign(filtered);
        }
        return result;
    }
}

