/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.preprocessing.unsupervised;

import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.Row;
import adams.ml.capabilities.Capabilities;
import adams.ml.capabilities.Capability;
import adams.ml.data.Dataset;
import adams.ml.data.DatasetUtils;
import adams.ml.data.DefaultDataset;
import adams.ml.preprocessing.AbstractColumnSubsetBatchFilter;
import com.github.waikatodatamining.matrix.core.Matrix;

public class PCA
extends AbstractColumnSubsetBatchFilter {
    private static final long serialVersionUID = 722136418091907244L;
    protected double m_Variance;
    protected int m_MaxColumns;
    protected boolean m_Center;
    protected com.github.waikatodatamining.matrix.algorithm.PCA m_Algorithm;
    protected int m_NumColumns;
    protected transient Matrix m_Transformed;

    public String globalInfo() {
        return "Performs principal components analysis.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("variance", "variance", (Object)0.95, (Number)0.0, (Number)1.0);
        this.m_OptionManager.add("max-columns", "maxColumns", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("center", "center", (Object)false);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Algorithm = null;
        this.m_NumColumns = -1;
    }

    public void setVariance(double value) {
        if (this.getOptionManager().isValid("variance", (Number)value)) {
            this.m_Variance = value;
            this.reset();
        }
    }

    public double getVariance() {
        return this.m_Variance;
    }

    public String varianceTipText() {
        return "The variance to cover.";
    }

    public void setMaxColumns(int value) {
        if (this.getOptionManager().isValid("maxColumns", (Number)value)) {
            this.m_MaxColumns = value;
            this.reset();
        }
    }

    public int getMaxColumns() {
        return this.m_MaxColumns;
    }

    public String maxColumnsTipText() {
        return "The maximum number of columns to generate.";
    }

    public void setCenter(boolean center) {
        this.m_Center = center;
        this.reset();
    }

    public boolean getCenter() {
        return this.m_Center;
    }

    public String centerTipText() {
        return "If enabled, the data gets centered rather than standardized, computing PCA from covariance matrix rather than correlation matrix.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities(this);
        result.enable(Capability.NUMERIC_ATTRIBUTE);
        result.enableAllClass();
        return result;
    }

    @Override
    protected void doInitFilter(Dataset data) throws Exception {
        this.m_Algorithm = new com.github.waikatodatamining.matrix.algorithm.PCA();
        this.m_Algorithm.setVariance(this.m_Variance);
        this.m_Algorithm.setMaxColumns(this.m_MaxColumns);
        this.m_Algorithm.setCenter(this.m_Center);
        this.m_Transformed = this.m_Algorithm.transform(DatasetUtils.numericToMatrixAlgo(data, this.m_DataColumns.toArray()));
        this.m_NumColumns = this.m_Transformed.numColumns();
    }

    @Override
    protected Dataset initOutputFormat(Dataset data) throws Exception {
        DefaultDataset result = new DefaultDataset();
        HeaderRow row = result.getHeaderRow();
        String prefix = "PCA_";
        for (int i = 0; i < this.m_NumColumns; ++i) {
            row.addCell(prefix + (i + 1)).setContentAsString(prefix + (i + 1));
        }
        this.appendHeader(data, (Row)row, this.m_OtherColumns);
        this.appendHeader(data, (Row)row, this.m_ClassColumns);
        return result;
    }

    @Override
    protected Dataset doFilter(Dataset data) throws Exception {
        Dataset result = this.getOutputFormat().getClone();
        String prefix = "PCA_";
        for (int y = 0; y < this.m_Transformed.numRows(); ++y) {
            DataRow rowIn = data.getRow(y);
            DataRow rowOut = result.addRow();
            for (int x = 0; x < this.m_Transformed.numColumns(); ++x) {
                rowOut.addCell(prefix + (x + 1)).setContent(Double.valueOf(this.m_Transformed.get(y, x)));
            }
            this.appendData((Row)rowIn, (Row)rowOut, this.m_OtherColumns);
            this.appendData((Row)rowIn, (Row)rowOut, this.m_ClassColumns);
        }
        return result;
    }
}

