/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.flow.core.Token;
import adams.flow.source.AbstractSource;
import moa.classifiers.Classifier;
import moa.classifiers.trees.DecisionStump;
import moa.options.ClassOption;
import weka.core.MOAUtils;

public class MOAClassifierSetup
extends AbstractSource {
    private static final long serialVersionUID = 1357925227105730412L;
    protected ClassOption m_Classifier;
    protected Token m_OutputToken;

    public String globalInfo() {
        return "Outputs an instance of the specified MOA classifier.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("classifier", "classifier", (Object)this.getDefaultOption());
    }

    protected Classifier getDefaultClassifier() {
        return new DecisionStump();
    }

    protected ClassOption getDefaultOption() {
        return new ClassOption("classifier", 'c', "The MOA classifier to use from within ADAMS.", Classifier.class, this.getDefaultClassifier().getClass().getName().replace("moa.classifiers.", ""), this.getDefaultClassifier().getClass().getName());
    }

    public void setClassifier(ClassOption value) {
        this.m_Classifier = (ClassOption)value.copy();
        this.reset();
    }

    public ClassOption getClassifier() {
        return this.m_Classifier;
    }

    public String classifierTipText() {
        return "The MOA classifier to output.";
    }

    protected Classifier getCurrentClassifier() {
        return (Classifier)MOAUtils.fromOption((ClassOption)this.m_Classifier);
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("classifier");
        if (variable != null) {
            return variable;
        }
        return this.getCurrentClassifier().getClass().getSimpleName();
    }

    public Class[] generates() {
        return new Class[]{Classifier.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            Classifier cls = (Classifier)MOAUtils.fromOption((ClassOption)this.m_Classifier);
            this.m_OutputToken = new Token((Object)cls);
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to create copy of classifier:", e);
        }
        return result;
    }

    public Token output() {
        Token result = this.m_OutputToken;
        this.m_OutputToken = null;
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_OutputToken != null;
    }
}

