/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.source.AbstractSource;
import moa.core.InstancesHeader;
import moa.options.ClassOption;
import moa.streams.InstanceStream;
import moa.streams.generators.AgrawalGenerator;
import weka.core.Instance;
import weka.core.MOAUtils;

public class MOAStream
extends AbstractSource
implements ProvenanceSupporter {
    private static final long serialVersionUID = 1862828539481494711L;
    protected InstanceStream m_ActualStreamGenerator;
    protected ClassOption m_StreamGenerator;
    protected int m_NumExamples;
    protected int m_CountExamples;

    public String globalInfo() {
        return "Generates artificial data using a MOA stream generator.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("stream", "streamGenerator", (Object)this.getDefaultOption());
        this.m_OptionManager.add("num-examples", "numExamples", (Object)10000, (Number)-1, null);
    }

    protected void reset() {
        super.reset();
        this.m_ActualStreamGenerator = null;
        this.m_CountExamples = 0;
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("evaluator");
        String result = variable != null ? variable : this.getCurrentStreamGenerator().getClass().getName().replace("moa.streams.", "");
        variable = this.getOptionManager().getVariableForProperty("numExamples");
        result = variable != null ? result + "/" + variable : result + "/" + (this.m_NumExamples == -1 ? "infinite" : Integer.valueOf(this.m_NumExamples));
        return result;
    }

    protected InstanceStream getDefaultGenerator() {
        return new AgrawalGenerator();
    }

    protected ClassOption getDefaultOption() {
        return new ClassOption("stream", 's', "The MOA stream generator to use from within ADAMS.", InstanceStream.class, this.getDefaultGenerator().getClass().getName().replace("moa.streams.", ""), this.getDefaultGenerator().getClass().getName());
    }

    public void setStreamGenerator(ClassOption value) {
        this.m_StreamGenerator = (ClassOption)value.copy();
        this.reset();
    }

    public ClassOption getStreamGenerator() {
        return this.m_StreamGenerator;
    }

    public String streamGeneratorTipText() {
        return "The stream generator to use for generating the weka.core.Instance objects.";
    }

    protected InstanceStream getCurrentStreamGenerator() {
        return (InstanceStream)MOAUtils.fromOption((ClassOption)this.m_StreamGenerator);
    }

    public void setNumExamples(int value) {
        this.m_NumExamples = value;
        this.reset();
    }

    public int getNumExamples() {
        return this.m_NumExamples;
    }

    public String numExamplesTipText() {
        return "The number of examples to generate; -1 means infinite.";
    }

    public Class[] generates() {
        return new Class[]{Instance.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            this.m_ActualStreamGenerator = this.getCurrentStreamGenerator();
            this.m_CountExamples = 0;
            InstancesHeader data = this.m_ActualStreamGenerator.getHeader();
            if (data == null) {
                result = "No header obtained from stream generator!";
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to generate stream: ", e);
        }
        return result;
    }

    public Token output() {
        Token result = new Token((Object)this.m_ActualStreamGenerator.nextInstance());
        if (this.m_NumExamples > -1) {
            ++this.m_CountExamples;
        }
        this.updateProvenance((ProvenanceContainer)result);
        return result;
    }

    public boolean hasPendingOutput() {
        boolean maxReached = this.m_NumExamples > -1 && this.m_CountExamples >= this.m_NumExamples;
        return this.m_ActualStreamGenerator != null && !maxReached && this.m_ActualStreamGenerator.hasMoreInstances();
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            cont.addProvenance(new ProvenanceInformation(ActorType.DATAGENERATOR, (AbstractActor)this, ((Token)cont).getPayload().getClass()));
        }
    }
}

