/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.container.WekaModelContainer;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorHelper;
import adams.flow.core.GlobalActorReference;
import adams.flow.core.Token;
import adams.flow.source.MOAClustererSetup;
import adams.flow.transformer.AbstractTransformer;
import java.util.Hashtable;
import moa.clusterers.Clusterer;
import weka.core.Instance;
import weka.core.Instances;

public class MOATrainClusterer
extends AbstractTransformer {
    private static final long serialVersionUID = -6015760924658904729L;
    public static final String BACKUP_CLUSTERER = "clusterer";
    protected GlobalActorReference m_Clusterer;
    protected Clusterer m_ActualClusterer;
    protected int m_OutputInterval;
    protected int m_Count;

    public String globalInfo() {
        return "Trains a MOA clusterer based on the incoming data.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add(BACKUP_CLUSTERER, BACKUP_CLUSTERER, (Object)new GlobalActorReference(MOAClustererSetup.class.getSimpleName()));
        this.m_OptionManager.add("output-interval", "outputInterval", (Object)1000, (Number)1, null);
    }

    protected void reset() {
        super.reset();
        this.m_ActualClusterer = null;
        this.m_Count = 0;
    }

    public void setClusterer(GlobalActorReference value) {
        this.m_Clusterer = value;
        this.reset();
    }

    public GlobalActorReference getClusterer() {
        return this.m_Clusterer;
    }

    public String clustererTipText() {
        return "The global MOA clusterer to train on the input data and outputs the built clusterer alongside the training header (in a model container).";
    }

    public void setOutputInterval(int value) {
        this.m_OutputInterval = value;
        this.reset();
    }

    public int getOutputInterval() {
        return this.m_OutputInterval;
    }

    public String outputIntervalTipText() {
        return "The number of tokens to wait before forwarding the trainined clusterer.";
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty(BACKUP_CLUSTERER);
        String result = variable != null ? variable : this.getClusterer().toString();
        variable = this.getOptionManager().getVariableForProperty("outputInterval");
        result = variable != null ? result + "/" + variable : result + "/" + this.m_OutputInterval;
        return result;
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_CLUSTERER);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_ActualClusterer != null) {
            result.put(BACKUP_CLUSTERER, this.m_ActualClusterer);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_CLUSTERER)) {
            this.m_ActualClusterer = (Clusterer)state.get(BACKUP_CLUSTERER);
            state.remove(BACKUP_CLUSTERER);
        }
        super.restoreState(state);
    }

    public Class[] accepts() {
        return new Class[]{Instance.class};
    }

    public Class[] generates() {
        return new Class[]{WekaModelContainer.class};
    }

    protected Clusterer getClustererInstance() {
        return (Clusterer)GlobalActorHelper.getSetup(Clusterer.class, (GlobalActorReference)this.m_Clusterer, (AbstractActor)this);
    }

    protected String doExecute() {
        String result = null;
        try {
            if (this.m_InputToken != null && this.m_InputToken.getPayload() instanceof Instance) {
                Instance inst = (Instance)this.m_InputToken.getPayload();
                if (this.m_ActualClusterer == null) {
                    this.m_ActualClusterer = this.getClustererInstance();
                }
                this.m_ActualClusterer.trainOnInstance(inst);
                ++this.m_Count;
                if (this.m_Count % this.m_OutputInterval == 0) {
                    this.m_Count = 0;
                    this.m_OutputToken = new Token((Object)new WekaModelContainer((Object)this.m_ActualClusterer, new Instances(inst.dataset(), 0)));
                }
            }
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to process input: " + this.m_InputToken.getPayload(), e);
        }
        return result;
    }

    public void wrapUp() {
        super.wrapUp();
        this.m_ActualClusterer = null;
    }
}

