/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.CallableActorReference;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.source.MOAClassifierSetup;
import adams.flow.standalone.CallableActors;
import adams.flow.transformer.MOAClassifierEvaluation;
import adams.flow.transformer.MOALearningEvaluation;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaFileReader;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import moa.classifiers.Classifier;
import moa.evaluation.BasicClassificationPerformanceEvaluator;
import moa.evaluation.ClassificationPerformanceEvaluator;
import moa.options.ClassOption;

public class MOAClassifierEvaluationTest
extends AbstractFlowTest {
    public MOAClassifierEvaluationTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("iris.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("iris.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public AbstractActor getActor() {
        ClassOption option = new ClassOption("classifier", 'c', "The MOA classifier to use from within ADAMS.", Classifier.class, "trees.DecisionStump", "moa.classifiers.trees.DecisionStump");
        MOAClassifierSetup cls = new MOAClassifierSetup();
        cls.setClassifier(option);
        cls.setName("classifier");
        CallableActors ga = new CallableActors();
        ga.setActors(new AbstractActor[]{cls});
        FileSupplier sfs = new FileSupplier();
        sfs.setFiles(new PlaceholderFile[]{new TmpFile("iris.arff")});
        WekaFileReader fr = new WekaFileReader();
        fr.setOutputType(WekaFileReader.OutputType.INCREMENTAL);
        WekaClassSelector cs = new WekaClassSelector();
        option = new ClassOption("evaluator", 'e', "The MOA classifier performance evaluator to use from within ADAMS.", ClassificationPerformanceEvaluator.class, "BasicClassificationPerformanceEvaluator", BasicClassificationPerformanceEvaluator.class.getName());
        MOAClassifierEvaluation mce = new MOAClassifierEvaluation();
        mce.setClassifier(new CallableActorReference("classifier"));
        mce.setEvaluator(option);
        mce.setOutputInterval(50);
        MOALearningEvaluation mle = new MOALearningEvaluation();
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{ga, sfs, fr, cs, mce, mle, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.txt"));
    }

    public static Test suite() {
        return new TestSuite(MOAClassifierEvaluationTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        MOAClassifierEvaluationTest.runTest((Test)MOAClassifierEvaluationTest.suite());
    }
}

