/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.CallableActorReference;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.source.MOARegressorSetup;
import adams.flow.standalone.CallableActors;
import adams.flow.transformer.MOATrainRegressor;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaFileReader;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import moa.classifiers.Regressor;
import moa.options.ClassOption;

public class MOATrainRegressorTest
extends AbstractFlowTest {
    public MOATrainRegressorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bolts.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bolts.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public AbstractActor getActor() {
        CallableActors ga = new CallableActors();
        ClassOption option = new ClassOption("regressor", 'r', "The MOA regressor to use from within ADAMS.", Regressor.class, "trees.FIMTDD", "moa.classifiers.trees.FIMTDD");
        MOARegressorSetup cls = new MOARegressorSetup();
        cls.setName("reg");
        cls.setRegressor(option);
        ga.add((AbstractActor)cls);
        FileSupplier sfs = new FileSupplier();
        sfs.setFiles(new PlaceholderFile[]{new TmpFile("bolts.arff")});
        WekaFileReader fr = new WekaFileReader();
        fr.setOutputType(WekaFileReader.OutputType.INCREMENTAL);
        WekaClassSelector cs = new WekaClassSelector();
        MOATrainRegressor cts = new MOATrainRegressor();
        cts.setRegressor(new CallableActorReference("reg"));
        cts.setOutputInterval(40);
        DumpFile df = new DumpFile();
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{ga, sfs, fr, cs, cts, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.txt"));
    }

    public static Test suite() {
        return new TestSuite(MOATrainRegressorTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        MOATrainRegressorTest.runTest((Test)MOATrainRegressorTest.suite());
    }
}

