/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.WekaModelContainer;
import adams.flow.core.AbstractActor;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.Token;
import adams.flow.source.MOARegressorSetup;
import adams.flow.transformer.AbstractTransformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import moa.classifiers.Classifier;
import moa.classifiers.Regressor;
import moa.classifiers.trees.DecisionStump;
import moa.options.ClassOption;
import weka.core.Instance;
import weka.core.Instances;

public class MOATrainRegressor
extends AbstractTransformer {
    private static final long serialVersionUID = 1410487605033307517L;
    public static final String BACKUP_REGRESSOR = "regressor";
    protected CallableActorReference m_Regressor;
    protected Classifier m_ActualRegressor;
    protected int m_OutputInterval;
    protected int m_Count;

    public String globalInfo() {
        return "Trains a MOA regressor based on the incoming data.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add(BACKUP_REGRESSOR, BACKUP_REGRESSOR, (Object)new CallableActorReference(MOARegressorSetup.class.getSimpleName()));
        this.m_OptionManager.add("output-interval", "outputInterval", (Object)1000, (Number)1, null);
    }

    protected void reset() {
        super.reset();
        this.m_ActualRegressor = null;
        this.m_Count = 0;
    }

    protected Classifier getDefaultClassifier() {
        return new DecisionStump();
    }

    protected ClassOption getDefaultOption() {
        return new ClassOption(BACKUP_REGRESSOR, 'r', "The MOA regressor to use from within ADAMS.", Classifier.class, this.getDefaultClassifier().getClass().getName().replace("moa.classifiers.", ""), this.getDefaultClassifier().getClass().getName());
    }

    public void setRegressor(CallableActorReference value) {
        this.m_Regressor = value;
        this.reset();
    }

    public CallableActorReference getRegressor() {
        return this.m_Regressor;
    }

    public String regressorTipText() {
        return "The callable MOA regressor to train on the input data and outputs the built regressor alongside the training header (in a model container).";
    }

    protected Classifier getRegressorInstance() {
        return (Classifier)CallableActorHelper.getSetup(Regressor.class, (CallableActorReference)this.m_Regressor, (AbstractActor)this);
    }

    public void setOutputInterval(int value) {
        this.m_OutputInterval = value;
        this.reset();
    }

    public int getOutputInterval() {
        return this.m_OutputInterval;
    }

    public String outputIntervalTipText() {
        return "The number of tokens to wait before forwarding the trained regressor.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)BACKUP_REGRESSOR, (Object)this.m_Regressor);
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"outputInterval", (Object)(this.m_OutputInterval == 1 ? "always" : Integer.valueOf(this.m_OutputInterval)), (String)"/");
        return result;
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_REGRESSOR);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_ActualRegressor != null) {
            result.put(BACKUP_REGRESSOR, this.m_ActualRegressor);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_REGRESSOR)) {
            this.m_ActualRegressor = (Classifier)state.get(BACKUP_REGRESSOR);
            state.remove(BACKUP_REGRESSOR);
        }
        super.restoreState(state);
    }

    public Class[] accepts() {
        return new Class[]{Instance.class, Instances.class};
    }

    public Class[] generates() {
        return new Class[]{WekaModelContainer.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            if (this.m_InputToken != null) {
                ArrayList<Instance> data = new ArrayList<Instance>();
                if (this.m_InputToken.getPayload() instanceof Instance) {
                    data.add((Instance)this.m_InputToken.getPayload());
                } else {
                    data.addAll((Collection<Instance>)((Instances)this.m_InputToken.getPayload()));
                }
                if (this.m_ActualRegressor == null) {
                    this.m_ActualRegressor = this.getRegressorInstance();
                }
                if (this.m_ActualRegressor == null) {
                    result = "Failed to located regressor '" + this.m_Regressor + "'!";
                    return result;
                }
                for (Instance inst : data) {
                    this.m_ActualRegressor.trainOnInstance(inst);
                }
                ++this.m_Count;
                if (this.m_Count % this.m_OutputInterval == 0) {
                    this.m_Count = 0;
                    this.m_OutputToken = new Token((Object)new WekaModelContainer((Object)this.m_ActualRegressor, new Instances(((Instance)data.get(0)).dataset(), 0)));
                }
            }
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to process input: " + this.m_InputToken.getPayload(), e);
        }
        return result;
    }

    public void wrapUp() {
        super.wrapUp();
        this.m_ActualRegressor = null;
    }
}

