/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorReference;
import adams.flow.sink.DumpFile;
import adams.flow.source.MOAClustererSetup;
import adams.flow.source.SingleFileSupplier;
import adams.flow.standalone.GlobalActors;
import adams.flow.transformer.MOATrainClusterer;
import adams.flow.transformer.WekaFileReader;
import adams.flow.transformer.WekaFilter;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import moa.clusterers.Clusterer;
import moa.options.ClassOption;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class MOAClustererSetupTest
extends AbstractFlowTest {
    public MOAClustererSetupTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("iris.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("iris.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public AbstractActor getActor() {
        GlobalActors ga = new GlobalActors();
        ClassOption option = new ClassOption("clusterer", 'c', "The MOA clusterer to use from within ADAMS.", Clusterer.class, "CobWeb", "moa.clusterers.CobWeb");
        MOAClustererSetup cls = new MOAClustererSetup();
        cls.setName("cls");
        cls.setClusterer(option);
        ga.add((AbstractActor)cls);
        SingleFileSupplier sfs = new SingleFileSupplier();
        sfs.setFile((PlaceholderFile)new TmpFile("iris.arff"));
        WekaFileReader fr = new WekaFileReader();
        fr.setOutputType(WekaFileReader.OutputType.INCREMENTAL);
        Remove remove = new Remove();
        remove.setAttributeIndices("last");
        WekaFilter wf = new WekaFilter();
        wf.setFilter((Filter)remove);
        MOATrainClusterer cts = new MOATrainClusterer();
        cts.setClusterer(new GlobalActorReference("cls"));
        cts.setOutputInterval(150);
        DumpFile df = new DumpFile();
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{ga, sfs, fr, wf, cts, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.txt"));
    }

    public static Test suite() {
        return new TestSuite(MOAClustererSetupTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        MOAClustererSetupTest.runTest((Test)MOAClustererSetupTest.suite());
    }
}

