/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.CallableActorReference;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.source.MOAClustererSetup;
import adams.flow.standalone.CallableActors;
import adams.flow.transformer.MOAClustererEvaluation;
import adams.flow.transformer.MOALearningEvaluation;
import adams.flow.transformer.WekaFileReader;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import moa.clusterers.Clusterer;
import moa.evaluation.BasicClusteringPerformanceEvaluator;
import moa.evaluation.LearningPerformanceEvaluator;
import moa.options.ClassOption;

public class MOAClustererEvaluationTest
extends AbstractFlowTest {
    public MOAClustererEvaluationTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("iris.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("iris.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public AbstractActor getActor() {
        ClassOption option = new ClassOption("clusterer", 'c', "The MOA clusterer to use from within ADAMS.", Clusterer.class, "CobWeb", "moa.clusterers.CobWeb");
        MOAClustererSetup cls = new MOAClustererSetup();
        cls.setClusterer(option);
        cls.setName("clusterer");
        CallableActors ga = new CallableActors();
        ga.setActors(new AbstractActor[]{cls});
        FileSupplier sfs = new FileSupplier();
        sfs.setFiles(new PlaceholderFile[]{new TmpFile("iris.arff")});
        WekaFileReader fr = new WekaFileReader();
        fr.setOutputType(WekaFileReader.OutputType.INCREMENTAL);
        option = new ClassOption("evaluator", 'e', "The MOA clusterer performance evaluator to use from within ADAMS.", LearningPerformanceEvaluator.class, "BasicClusteringPerformanceEvaluator", BasicClusteringPerformanceEvaluator.class.getName());
        MOAClustererEvaluation mce = new MOAClustererEvaluation();
        mce.setClusterer(new CallableActorReference("clusterer"));
        mce.setEvaluator(option);
        mce.setOutputInterval(50);
        MOALearningEvaluation mle = new MOALearningEvaluation();
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{ga, sfs, fr, mce, mle, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.txt"));
    }

    public static Test suite() {
        return new TestSuite(MOAClustererEvaluationTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        MOAClustererEvaluationTest.runTest((Test)MOAClustererEvaluationTest.suite());
    }
}

