/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.processor;

import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.MutableActorHandler;
import adams.flow.processor.AbstractModifyingProcessor;
import adams.flow.processor.CleanUpProcessor;
import adams.flow.source.MOAClassifierSetup;
import adams.flow.standalone.CallableActors;
import adams.flow.transformer.MOAClassifier;
import adams.flow.transformer.MOATrainClassifier;
import java.util.List;

public class FixDeprecatedMOAClassifier
extends AbstractModifyingProcessor
implements CleanUpProcessor {
    private static final long serialVersionUID = -4170658262349662939L;

    public String globalInfo() {
        return "Replaces the MOAClassifier transformer with MOAClassifierSetup and MOATrainClassifier instances";
    }

    protected void processActor(AbstractActor actor) {
        List classifiers = ActorUtils.enumerate((AbstractActor)actor, (Class[])new Class[]{MOAClassifier.class});
        for (AbstractActor classifier : classifiers) {
            MOAClassifier cactor = (MOAClassifier)classifier;
            String var = cactor.getOptionManager().getVariableForProperty("classifier");
            if (cactor.getParent() instanceof CallableActors) {
                MOAClassifierSetup setup = new MOAClassifierSetup();
                setup.setClassifier(cactor.getClassifier());
                if (var != null) {
                    setup.getOptionManager().setVariableForProperty("classifier", var);
                }
                setup.setName(cactor.getName());
                ((MutableActorHandler)cactor.getParent()).set(cactor.index(), (AbstractActor)setup);
                this.m_Modified = true;
                continue;
            }
            CallableActors callable = CallableActorHelper.createCallableActors((AbstractActor)cactor, (boolean)true);
            MOAClassifierSetup setup = new MOAClassifierSetup();
            setup.setClassifier(cactor.getClassifier());
            if (var != null) {
                setup.getOptionManager().setVariableForProperty("classifier", var);
            }
            callable.add((AbstractActor)setup);
            MOATrainClassifier train = new MOATrainClassifier();
            train.setClassifier(new CallableActorReference(setup.getName()));
            train.setOutputInterval(cactor.getOutputInterval());
            train.setName(cactor.getName());
            ((MutableActorHandler)cactor.getParent()).set(cactor.index(), (AbstractActor)train);
            this.m_Modified = true;
        }
    }
}

