/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorReference;
import adams.flow.sink.MOAModelWriter;
import adams.flow.source.FileSupplier;
import adams.flow.source.MOAClassifierSetup;
import adams.flow.standalone.CallableActors;
import adams.flow.transformer.MOATrainClassifier;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaFileReader;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import moa.classifiers.Classifier;
import moa.options.ClassOption;

public class MOAModelWriterTest
extends AbstractFlowTest {
    public MOAModelWriterTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("iris.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.model");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("iris.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.model");
        super.tearDown();
    }

    public Actor getActor() {
        CallableActors call = new CallableActors();
        ClassOption option = new ClassOption("classifier", 'c', "The MOA classifier to use from within ADAMS.", Classifier.class, "bayes.NaiveBayes", "moa.classifiers.bayes.NaiveBayes");
        MOAClassifierSetup cls = new MOAClassifierSetup();
        cls.setName("classifier");
        cls.setClassifier(option);
        call.add((Actor)cls);
        FileSupplier sfs = new FileSupplier();
        sfs.setFiles(new PlaceholderFile[]{new TmpFile("iris.arff")});
        WekaFileReader fr = new WekaFileReader();
        fr.setOutputType(WekaFileReader.OutputType.INCREMENTAL);
        WekaClassSelector cs = new WekaClassSelector();
        MOATrainClassifier train = new MOATrainClassifier();
        train.setClassifier(new CallableActorReference("classifier"));
        train.setOutputInterval(150);
        MOAModelWriter mw = new MOAModelWriter();
        mw.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.model"));
        Flow flow = new Flow();
        flow.setActors(new Actor[]{call, sfs, fr, cs, train, mw});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.model"));
    }

    public static Test suite() {
        return new TestSuite(MOAModelWriterTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        MOAModelWriterTest.runTest((Test)MOAModelWriterTest.suite());
    }
}

