/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorReference;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.source.MOARegressorSetup;
import adams.flow.standalone.CallableActors;
import adams.flow.transformer.MOALearningEvaluation;
import adams.flow.transformer.MOARegressorEvaluation;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaFileReader;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import moa.classifiers.Regressor;
import moa.evaluation.BasicRegressionPerformanceEvaluator;
import moa.evaluation.RegressionPerformanceEvaluator;
import moa.options.ClassOption;

public class MOARegressorEvaluationTest
extends AbstractFlowTest {
    public MOARegressorEvaluationTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bolts.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bolts.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public Actor getActor() {
        ClassOption option = new ClassOption("regressor", 'r', "The MOA regressor to use from within ADAMS.", Regressor.class, "trees.FIMTDD", "moa.classifiers.trees.FIMTDD");
        MOARegressorSetup cls = new MOARegressorSetup();
        cls.setRegressor(option);
        cls.setName("reg");
        CallableActors ga = new CallableActors();
        ga.setActors(new Actor[]{cls});
        FileSupplier sfs = new FileSupplier();
        sfs.setFiles(new PlaceholderFile[]{new TmpFile("bolts.arff")});
        WekaFileReader fr = new WekaFileReader();
        fr.setOutputType(WekaFileReader.OutputType.INCREMENTAL);
        WekaClassSelector cs = new WekaClassSelector();
        option = new ClassOption("evaluator", 'e', "The MOA classifier performance evaluator to use from within ADAMS.", RegressionPerformanceEvaluator.class, "BasicRegressionPerformanceEvaluator", BasicRegressionPerformanceEvaluator.class.getName());
        MOARegressorEvaluation mce = new MOARegressorEvaluation();
        mce.setRegressor(new CallableActorReference("reg"));
        mce.setEvaluator(option);
        mce.setOutputInterval(40);
        MOALearningEvaluation mle = new MOALearningEvaluation();
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new Actor[]{ga, sfs, fr, cs, mce, mle, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.txt"));
    }

    public static Test suite() {
        return new TestSuite(MOARegressorEvaluationTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        MOARegressorEvaluationTest.runTest((Test)MOARegressorEvaluationTest.suite());
    }
}

