/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.ClassLocator;
import adams.core.Utils;
import adams.core.base.BaseMeasureCollection;
import adams.core.option.AbstractOption;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import adams.gui.goe.MultiLineValueDialog;
import adams.gui.goe.MultiSelectionEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import moa.evaluation.MeasureCollection;

public class BaseMeasureCollectionEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler,
MultiSelectionEditor {
    protected JComboBox<String> m_ComboBoxValue;

    public static String toString(AbstractOption option, Object object) {
        return ((BaseMeasureCollection)((Object)object)).getValue();
    }

    public static Object valueOf(AbstractOption option, String str) {
        return new BaseMeasureCollection(str);
    }

    public String toCustomStringRepresentation(Object obj) {
        return BaseMeasureCollectionEditor.toString(null, obj);
    }

    public Object fromCustomStringRepresentation(String str) {
        return new BaseMeasureCollection(str);
    }

    public String getJavaInitializationString() {
        String result = "new " + BaseMeasureCollection.class.getName() + "(\"" + Utils.backQuoteChars((String)this.getValue().toString()) + "\")";
        return result;
    }

    protected String getStringToPaint() {
        return "" + this.getValue();
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        String val = this.getStringToPaint();
        if (val.isEmpty()) {
            val = "[empty]";
        }
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }

    protected BaseMeasureCollection parse(String s) {
        BaseMeasureCollection result;
        try {
            result = new BaseMeasureCollection(s);
            result.setValue(s);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    protected JComponent createCustomEditor() {
        JPanel panelAll = new JPanel(new BorderLayout());
        JPanel panel = new JPanel(new FlowLayout(0));
        panelAll.add((Component)panel, "Center");
        List classes = ClassLocator.getSingleton().findNames(MeasureCollection.class, new String[]{"moa.evaluation"});
        for (int i = 0; i < classes.size(); ++i) {
            classes.set(i, ((String)classes.get(i)).replaceAll(".*\\.", ""));
        }
        this.m_ComboBoxValue = new JComboBox<String>(classes.toArray(new String[classes.size()]));
        this.m_ComboBoxValue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    BaseMeasureCollectionEditor.this.acceptInput();
                } else if (e.getKeyCode() == 27) {
                    e.consume();
                    BaseMeasureCollectionEditor.this.discardInput();
                } else {
                    super.keyPressed(e);
                }
            }
        });
        JLabel label = new JLabel("Measure collection");
        label.setDisplayedMnemonic('M');
        label.setLabelFor(this.m_ComboBoxValue);
        panel.add(label);
        panel.add(this.m_ComboBoxValue);
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        panelAll.add((Component)panelButtons, "South");
        JButton buttonOK = new JButton("OK");
        buttonOK.setMnemonic('O');
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseMeasureCollectionEditor.this.acceptInput();
            }
        });
        panelButtons.add(buttonOK);
        JButton buttonClose = new JButton("Cancel");
        buttonClose.setMnemonic('C');
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseMeasureCollectionEditor.this.discardInput();
            }
        });
        panelButtons.add(buttonClose);
        return panelAll;
    }

    protected boolean isValid(String s) {
        return ((BaseMeasureCollection)((Object)this.getValue())).isValid(s);
    }

    protected boolean isUnchanged(String s) {
        return s.equals(((BaseMeasureCollection)((Object)this.getValue())).getValue());
    }

    protected void acceptInput() {
        String s = this.m_ComboBoxValue.getSelectedItem().toString();
        if (this.isValid(s) && !this.isUnchanged(s)) {
            this.setValue((Object)this.parse(s));
        }
        this.closeDialog(1);
    }

    protected void discardInput() {
        this.closeDialog(0);
    }

    protected void initForDisplay() {
        super.initForDisplay();
        if (this.m_ComboBoxValue.getSelectedIndex() == -1 || !this.m_ComboBoxValue.getSelectedItem().toString().equals("" + this.getValue())) {
            this.m_ComboBoxValue.setSelectedItem("" + this.getValue());
        }
        this.m_ComboBoxValue.setToolTipText(((BaseMeasureCollection)((Object)this.getValue())).getTipText());
        this.m_ComboBoxValue.grabFocus();
    }

    public Object[] getSelectedObjects(Container parent) {
        Object[] result;
        MultiLineValueDialog dialog = new MultiLineValueDialog();
        dialog.setInfoText("Enter the measure collection names, one per line:");
        dialog.setLocationRelativeTo((Component)parent);
        dialog.setVisible(true);
        if (dialog.getOption() == 0) {
            Vector<String> lines = new Vector<String>(Arrays.asList(dialog.getContent().split("\n")));
            Utils.removeEmptyLines(lines);
            result = (Object[])Array.newInstance(BaseMeasureCollection.class, lines.size());
            for (int i = 0; i < lines.size(); ++i) {
                Array.set(result, i, (Object)this.parse(lines.get(i)));
            }
        } else {
            result = (Object[])Array.newInstance(BaseMeasureCollection.class, 0);
        }
        return result;
    }
}

